/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto.asymmetric;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.asymmetric.SM2;
import com.cyberway.mp.bc.common.crypto.CryptoProvider;
import com.cyberway.mp.bc.common.crypto.asymmetric.AsymmetricAlgorithmType;
import com.cyberway.mp.bc.common.crypto.asymmetric.AsymmetricConfig;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricCryptoProvider
implements CryptoProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AsymmetricAlgorithmType type;
    private RSA rsa;
    private SM2 sm2;
    private final Function<String, byte[]> encodeFunction;
    private final Function<byte[], String> decodeFunction;

    public AsymmetricCryptoProvider(AsymmetricConfig asymmetricConfig) {
        AsymmetricAlgorithmType asymmetricAlgorithmType = AsymmetricAlgorithmType.fromName(asymmetricConfig.getAsymmetricAlgorithm());
        if (null == asymmetricAlgorithmType) {
            AsymmetricCryptoProvider.throwUnSupportType(asymmetricConfig.getAsymmetricAlgorithm());
        }
        this.type = asymmetricAlgorithmType;
        PrivateKey privateKey = StringUtils.isBlank((CharSequence)asymmetricConfig.getPrivateKeyBase64()) ? null : SecureUtil.generatePrivateKey((String)this.type.getValue(), (byte[])Base64.decode((String)asymmetricConfig.getPrivateKeyBase64()));
        PublicKey publicKey = this.getPublicKey(asymmetricConfig);
        switch (this.type) {
            case RSA: 
            case RSA_NONE: 
            case RSA_ECB: 
            case RSA_ECB_PKCS1: {
                this.rsa = new RSA(this.type.getValue(), privateKey, publicKey);
                this.decodeFunction = bytes -> new String(this.rsa.decrypt(bytes, KeyType.PrivateKey), StandardCharsets.UTF_8);
                this.encodeFunction = content -> this.rsa.encrypt(content.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey);
                break;
            }
            case SM2: {
                this.sm2 = SmUtil.sm2((PrivateKey)privateKey, (PublicKey)publicKey);
                if (SM2Engine.Mode.C1C2C3.name().equalsIgnoreCase(asymmetricConfig.getSm2Mode())) {
                    this.sm2.setMode(SM2Engine.Mode.C1C2C3);
                } else if (SM2Engine.Mode.C1C3C2.name().equalsIgnoreCase(asymmetricConfig.getSm2Mode())) {
                    this.sm2.setMode(SM2Engine.Mode.C1C3C2);
                }
                this.decodeFunction = bytes -> new String(this.sm2.decrypt(bytes, KeyType.PrivateKey), StandardCharsets.UTF_8);
                this.encodeFunction = content -> this.sm2.encrypt(content.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported asymmetric algorithm type: " + asymmetricConfig.getAsymmetricAlgorithm());
            }
        }
    }

    private PublicKey getPublicKey(AsymmetricConfig asymmetricConfig) {
        PublicKey publicKey = null;
        try {
            publicKey = StringUtils.isBlank((CharSequence)asymmetricConfig.getPublicKeyBase64()) ? null : SecureUtil.generatePublicKey((String)this.type.getValue(), (byte[])Base64.decode((String)asymmetricConfig.getPublicKeyBase64()));
        }
        catch (CryptoException exception) {
            ASN1Sequence asn1 = ASN1Sequence.getInstance((Object)Base64.decode((String)asymmetricConfig.getPublicKeyBase64()));
            Enumeration e = asn1.getObjects();
            BigInteger modulus = ASN1Integer.getInstance(e.nextElement()).getPositiveValue();
            BigInteger publicExponent = ASN1Integer.getInstance(e.nextElement()).getPositiveValue();
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey pubKeyX509 = keyFactory.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
                byte[] x509Encoded = pubKeyX509.getEncoded();
                return SecureUtil.generatePublicKey((String)this.type.getValue(), (byte[])x509Encoded);
            }
            catch (Exception ex) {
                this.logger.error("", (Throwable)ex);
            }
        }
        return publicKey;
    }

    private static void throwUnSupportType(String typeName) {
        throw new IllegalArgumentException("Unsupported asymmetric algorithm type: " + typeName);
    }

    @Override
    public String decode(byte[] content) {
        return this.decodeFunction.apply(content);
    }

    @Override
    public byte[] encode(String content) {
        return this.encodeFunction.apply(content);
    }

    @Override
    public boolean match(String content, byte[] encodeContent) {
        return StringUtils.equals((CharSequence)content, (CharSequence)this.decode(encodeContent));
    }
}

