/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto.digest;

import com.cyberway.mp.bc.common.crypto.CryptoConfig;
import com.cyberway.mp.bc.common.crypto.CryptoType;
import com.cyberway.mp.bc.common.crypto.digest.DigestAlgorithmType;

public class DigestConfig {
    private String digestAlgorithm = DigestAlgorithmType.MD5.name();
    private String salt;
    private int bcryptSaltRounds = 4;

    public int getBcryptSaltRounds() {
        return this.bcryptSaltRounds;
    }

    public void setBcryptSaltRounds(int bcryptSaltRounds) {
        this.bcryptSaltRounds = bcryptSaltRounds;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public static final class ConfigBuilder {
        private String digestAlgorithm;
        private String salt;
        private int bcryptSaltRounds;

        public ConfigBuilder digestAlgorithm(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        public ConfigBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public ConfigBuilder bcryptSaltRounds(int bcryptSaltRounds) {
            this.bcryptSaltRounds = bcryptSaltRounds;
            return this;
        }

        public CryptoConfig build() {
            DigestConfig digestConfig = new DigestConfig();
            digestConfig.setDigestAlgorithm(this.digestAlgorithm);
            digestConfig.setSalt(this.salt);
            digestConfig.setBcryptSaltRounds(this.bcryptSaltRounds);
            CryptoConfig config = new CryptoConfig();
            config.setType(CryptoType.DIGEST.name());
            config.setDigest(digestConfig);
            return config;
        }
    }
}

