/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto.digest;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.digest.BCrypt;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.digest.SM3;
import com.cyberway.mp.bc.common.crypto.CryptoProvider;
import com.cyberway.mp.bc.common.crypto.digest.DigestAlgorithmType;
import com.cyberway.mp.bc.common.crypto.digest.DigestConfig;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class DigestCryptoProvider
implements CryptoProvider {
    private final DigestAlgorithmType type;
    private Digester digester;
    private SM3 sm3;
    private Integer bcryptSaltRounds;

    public DigestCryptoProvider(DigestConfig digestConfig) {
        byte[] salt;
        DigestAlgorithmType digestAlgorithmType;
        this.type = digestAlgorithmType = DigestAlgorithmType.fromName(digestConfig.getDigestAlgorithm());
        if (null == digestAlgorithmType) {
            throw new IllegalArgumentException("Unsupported digest algorithm type: " + digestConfig.getDigestAlgorithm());
        }
        switch (digestAlgorithmType) {
            case MD2: {
                this.digester = new Digester(DigestAlgorithm.MD2);
                break;
            }
            case MD5: {
                this.digester = new Digester(DigestAlgorithm.MD5);
                break;
            }
            case SHA1: {
                this.digester = new Digester(DigestAlgorithm.SHA1);
                break;
            }
            case SHA256: {
                this.digester = new Digester(DigestAlgorithm.SHA256);
                break;
            }
            case SHA384: {
                this.digester = new Digester(DigestAlgorithm.SHA384);
                break;
            }
            case SHA512: {
                this.digester = new Digester(DigestAlgorithm.SHA512);
                break;
            }
            case SM3: {
                this.sm3 = SmUtil.sm3();
                break;
            }
            case BCRYPT: {
                this.bcryptSaltRounds = digestConfig.getBcryptSaltRounds();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported digest algorithm type: " + digestConfig.getDigestAlgorithm());
            }
        }
        byte[] byArray = salt = digestConfig.getSalt() == null ? null : digestConfig.getSalt().getBytes(StandardCharsets.UTF_8);
        if (null != this.digester) {
            this.digester.setSalt(salt);
        }
        if (null != this.sm3) {
            this.sm3.setSalt(salt);
        }
    }

    @Override
    public String decode(byte[] content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] encode(String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            if (null != this.digester) {
                return this.digester.digest(content, StandardCharsets.UTF_8);
            }
            if (null != this.sm3) {
                return this.sm3.digest(content, StandardCharsets.UTF_8);
            }
            if (this.type == DigestAlgorithmType.BCRYPT && this.bcryptSaltRounds != null && this.bcryptSaltRounds > 0) {
                return BCrypt.hashpw((String)content, (String)BCrypt.gensalt((int)this.bcryptSaltRounds)).getBytes(StandardCharsets.UTF_8);
            }
        }
        return new byte[0];
    }

    @Override
    public boolean match(String content, byte[] encodeContent) {
        if (this.type == DigestAlgorithmType.BCRYPT) {
            return DigestUtil.bcryptCheck((String)content, (String)new String(encodeContent, StandardCharsets.UTF_8));
        }
        return CryptoProvider.super.match(content, encodeContent);
    }

    @Override
    public boolean matchStr(String content, String encodeStr) {
        if (this.type == DigestAlgorithmType.BCRYPT) {
            return DigestUtil.bcryptCheck((String)content, (String)encodeStr);
        }
        return CryptoProvider.super.matchStr(content, encodeStr);
    }

    @Override
    public String encodeStr(String content) {
        if (this.type == DigestAlgorithmType.BCRYPT) {
            return BCrypt.hashpw((String)content, (String)BCrypt.gensalt((int)this.bcryptSaltRounds));
        }
        return CryptoProvider.super.encodeStr(content);
    }
}

