/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto.symmetric;

import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import com.cyberway.mp.bc.common.crypto.CryptoConfig;
import com.cyberway.mp.bc.common.crypto.CryptoType;
import com.cyberway.mp.bc.common.crypto.symmetric.SymmetricAlgorithmType;

public class SymmetricConfig {
    private String symmetricAlgorithm = SymmetricAlgorithmType.AES.name();
    private String mode = Mode.ECB.name();
    private String padding = Padding.NoPadding.name();
    private String iv;
    private String key = "0s10g0x0c40s30Pd";

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getSymmetricAlgorithm() {
        return this.symmetricAlgorithm;
    }

    public void setSymmetricAlgorithm(String symmetricAlgorithm) {
        this.symmetricAlgorithm = symmetricAlgorithm;
    }

    public static final class ConfigBuilder {
        private String symmetricAlgorithm;
        private String mode;
        private String padding;
        private String iv;
        private String key;

        public ConfigBuilder symmetricAlgorithm(String symmetricAlgorithm) {
            this.symmetricAlgorithm = symmetricAlgorithm;
            return this;
        }

        public ConfigBuilder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public ConfigBuilder padding(String padding) {
            this.padding = padding;
            return this;
        }

        public ConfigBuilder iv(String iv) {
            this.iv = iv;
            return this;
        }

        public ConfigBuilder key(String key) {
            this.key = key;
            return this;
        }

        public CryptoConfig build() {
            SymmetricConfig symmetricConfig = new SymmetricConfig();
            symmetricConfig.setSymmetricAlgorithm(this.symmetricAlgorithm);
            symmetricConfig.setMode(this.mode);
            symmetricConfig.setPadding(this.padding);
            symmetricConfig.setIv(this.iv);
            symmetricConfig.setKey(this.key);
            CryptoConfig config = new CryptoConfig();
            config.setType(CryptoType.SYMMETRIC.name());
            config.setSymmetric(symmetricConfig);
            return config;
        }
    }
}

