/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto.symmetric;

import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.DES;
import cn.hutool.crypto.symmetric.SM4;
import com.cyberway.mp.bc.common.crypto.CryptoProvider;
import com.cyberway.mp.bc.common.crypto.symmetric.SymmetricAlgorithmType;
import com.cyberway.mp.bc.common.crypto.symmetric.SymmetricConfig;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public class SymmetricCryptoProvider
implements CryptoProvider {
    private final SymmetricAlgorithmType type;
    private AES aes;
    private DES des;
    private SM4 sm4;
    private final Function<String, byte[]> encodeFunction;
    private final Function<byte[], String> decodeFunction;

    public SymmetricCryptoProvider(SymmetricConfig symmetricConfig) {
        SymmetricAlgorithmType symmetricAlgorithmType = SymmetricAlgorithmType.fromName(symmetricConfig.getSymmetricAlgorithm());
        if (null == symmetricAlgorithmType) {
            throw new IllegalArgumentException("Unsupported symmetric algorithm type: " + symmetricConfig.getSymmetricAlgorithm());
        }
        this.type = symmetricAlgorithmType;
        switch (this.type) {
            case AES: {
                this.aes = new AES(symmetricConfig.getMode(), symmetricConfig.getPadding(), symmetricConfig.getKey().getBytes(StandardCharsets.UTF_8), symmetricConfig.getIv() == null ? null : symmetricConfig.getIv().getBytes(StandardCharsets.UTF_8));
                this.decodeFunction = bytes -> this.aes.decryptStr(bytes, StandardCharsets.UTF_8);
                this.encodeFunction = content -> this.aes.encrypt(content, StandardCharsets.UTF_8);
                break;
            }
            case DES: {
                this.des = new DES(symmetricConfig.getMode(), symmetricConfig.getPadding(), symmetricConfig.getKey().getBytes(StandardCharsets.UTF_8), symmetricConfig.getIv() == null ? null : symmetricConfig.getIv().getBytes(StandardCharsets.UTF_8));
                this.decodeFunction = bytes -> this.des.decryptStr(bytes, StandardCharsets.UTF_8);
                this.encodeFunction = content -> this.des.encrypt(content, StandardCharsets.UTF_8);
                break;
            }
            case SM4: {
                this.sm4 = new SM4(symmetricConfig.getMode(), symmetricConfig.getPadding(), symmetricConfig.getKey().getBytes(StandardCharsets.UTF_8), symmetricConfig.getIv() == null ? null : symmetricConfig.getIv().getBytes(StandardCharsets.UTF_8));
                this.decodeFunction = bytes -> this.sm4.decryptStr(bytes, StandardCharsets.UTF_8);
                this.encodeFunction = content -> this.sm4.encrypt(content, StandardCharsets.UTF_8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported symmetric algorithm type: " + symmetricConfig.getSymmetricAlgorithm());
            }
        }
    }

    @Override
    public String decode(byte[] content) {
        return this.decodeFunction.apply(content);
    }

    @Override
    public byte[] encode(String content) {
        return this.encodeFunction.apply(content);
    }
}

