/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.feign;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.bc.common.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExceptionFeignErrorDecoder
extends ErrorDecoder.Default {
    private static final String JSON_START_CHAR = "{";
    private static final TypeReference<ResponseResult<String>> RESPONSE_RESULT_TYPE_REFERENCE = new TypeReference<ResponseResult<String>>(){};
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Exception decode(String methodKey, Response response) {
        try {
            Response.Body body = response.body();
            if (body != null) {
                String message = Util.toString((Reader)body.asReader(StandardCharsets.UTF_8));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Call feign method [{}] fail, status code [{}], body [{}]", new Object[]{methodKey, response.status(), message});
                }
                if (StringUtils.isNotBlank((CharSequence)message) && message.trim().startsWith(JSON_START_CHAR)) {
                    ResponseResult<String> result = JsonUtils.toObject(message, RESPONSE_RESULT_TYPE_REFERENCE);
                    return new BaseException(result.getErrorCode(), result.getMsg());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Decode feign exception fail: {}", (Object)e.getMessage(), (Object)e);
        }
        return super.decode(methodKey, response);
    }
}

