/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.interceptor;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.interceptor.KeyGenerator;
import com.cyberway.mp.bc.common.interceptor.RepeatedSubmitInterceptorProperties;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RepeatedSubmitInterceptor
implements MethodInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REDIS_KEY_PREFIX = "mp:bc:rsi:";
    private final List<RepeatedSubmitInterceptorProperties.InterceptorConfig> configList;
    private final RedisTemplate<Object, Object> template;
    private final Map<String, KeyGenerator> keyGeneratorMap = new ConcurrentHashMap<String, KeyGenerator>();

    public RepeatedSubmitInterceptor(List<RepeatedSubmitInterceptorProperties.InterceptorConfig> configList, RedisTemplate<Object, Object> template) {
        this.configList = configList;
        this.template = template;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        RepeatedSubmitInterceptorProperties.InterceptorConfig interceptorConfig = this.matchMethod(method);
        if (null != interceptorConfig) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u9632\u6b62\u91cd\u590d\u63d0\u4ea4\u62e6\u622a\u65b9\u6cd5\uff1a{}", (Object)method.getName());
            }
            Object[] arguments = invocation.getArguments();
            KeyGenerator keyGenerator = this.buildKeyGenerator(interceptorConfig.getKeyGenerator());
            String key = String.format("%s%s", REDIS_KEY_PREFIX, keyGenerator.generate(invocation.getThis(), method, arguments));
            Boolean success = this.template.opsForValue().setIfAbsent((Object)key, (Object)1, (long)interceptorConfig.getUnitMilliseconds(), TimeUnit.MILLISECONDS);
            if (!Boolean.TRUE.equals(success)) {
                throw new BaseException("00000001", "\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u8bd5\uff01");
            }
        }
        return invocation.proceed();
    }

    private KeyGenerator buildKeyGenerator(String keyGeneratorClassName) {
        if (StringUtils.isBlank((CharSequence)keyGeneratorClassName)) {
            keyGeneratorClassName = "com.cyberway.mp.bc.common.interceptor.SimpleKeyGenerator";
        }
        return this.keyGeneratorMap.computeIfAbsent(keyGeneratorClassName, className -> {
            try {
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (KeyGenerator)instance;
            }
            catch (Exception e) {
                this.logger.error("KeyGenerator\u5b9e\u4f8b\u5316\u5931\u8d25", (Throwable)e);
                throw new BaseException("00000001", "KeyGenerator[" + className + "]\u5b9e\u4f8b\u5316\u5931\u8d25");
            }
        });
    }

    private RepeatedSubmitInterceptorProperties.InterceptorConfig matchMethod(Method method) {
        String methodName = method.getName();
        return this.configList.stream().filter(config -> config.getMethodName().equals(methodName)).findFirst().orElse(null);
    }
}

