/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.lb;

import com.alibaba.cloud.nacos.balancer.NacosBalancer;
import com.cyberway.mp.bc.common.lb.MpLoadBalancerProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MpLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final String TAG_KEY = "tag";
    public static final String TAG_ENV_KEY = "spring.cloud.nacos.discovery.metadata.tag";
    private static final Logger log = LoggerFactory.getLogger(MpLoadBalancer.class);
    private final String serviceId;
    private final String envTag;
    private ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final MpLoadBalancerProperties properties;

    public MpLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, String envTag, MpLoadBalancerProperties properties) {
        this.serviceId = serviceId;
        this.envTag = envTag;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.properties = properties;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return ((Flux)supplier.get()).next().map(serviceInstances -> this.getInstanceResponse((List<ServiceInstance>)serviceInstances, request));
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> serviceInstances, Request request) {
        if (serviceInstances.isEmpty()) {
            log.warn("No servers available for service: {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        try {
            String ipPort;
            Map<String, String> serviceMappings = this.properties.getServiceMappings();
            if (null != serviceMappings && serviceMappings.containsKey(this.serviceId) && StringUtils.isNotBlank((CharSequence)(ipPort = serviceMappings.get(this.serviceId)))) {
                log.info("call service [{}] by mapping: [{}]", (Object)this.serviceId, (Object)ipPort);
                DefaultServiceInstance instance = new DefaultServiceInstance();
                String[] arr = ipPort.split(":");
                instance.setInstanceId(this.serviceId);
                instance.setHost(arr[0]);
                instance.setPort(Integer.parseInt(arr[1]));
                return new DefaultResponse((ServiceInstance)instance);
            }
            String tag = this.resolveTag(request);
            String defaultTag = "default";
            List<ServiceInstance> instancesToChoose = null;
            Map<String, List<ServiceInstance>> instancesGroupByTag = serviceInstances.stream().collect(Collectors.groupingBy(o -> Optional.ofNullable((String)o.getMetadata().get(TAG_KEY)).orElse(defaultTag)));
            if (StringUtils.isNotBlank((CharSequence)tag)) {
                if (instancesGroupByTag.containsKey(tag) && !instancesGroupByTag.get(tag).isEmpty()) {
                    log.info("call service [{}] by tag: [{}]", (Object)this.serviceId, (Object)tag);
                    instancesToChoose = instancesGroupByTag.get(tag);
                } else {
                    log.warn("no service [{}] found by tag: [{}]", (Object)this.serviceId, (Object)tag);
                }
            }
            if (null == instancesToChoose || instancesToChoose.isEmpty()) {
                log.info("call service [{}] by default", (Object)this.serviceId);
                instancesToChoose = instancesGroupByTag.get(defaultTag);
                if (null == instancesToChoose || instancesToChoose.isEmpty()) {
                    log.warn("No default servers available for service: {}", (Object)this.serviceId);
                    return new EmptyResponse();
                }
            }
            ServiceInstance instance = NacosBalancer.getHostByRandomWeight3((List)instancesToChoose);
            return new DefaultResponse(instance);
        }
        catch (Exception e) {
            log.warn("MpLoadBalancer error", (Throwable)e);
            return null;
        }
    }

    private String resolveTag(Request request) {
        String tag = null;
        Object requestContext = request.getContext();
        if (requestContext instanceof RequestDataContext) {
            RequestDataContext requestDataContext = (RequestDataContext)requestContext;
            HttpHeaders headers = requestDataContext.getClientRequest().getHeaders();
            tag = headers.getFirst("mp-tag");
        }
        return StringUtils.isBlank(tag) ? this.envTag : tag;
    }
}

