/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.lb;

import com.cyberway.mp.bc.common.lb.MpLoadBalancer;
import com.cyberway.mp.bc.common.lb.MpLoadBalancerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnDiscoveryEnabled
@EnableConfigurationProperties(value={MpLoadBalancerProperties.class})
public class MpLoadBalancerClientConfiguration {
    private final Logger logger = LoggerFactory.getLogger(MpLoadBalancerClientConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ReactorLoadBalancer<ServiceInstance> mpLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, MpLoadBalancerProperties properties) {
        this.logger.info("mpLoadBalancer init");
        String name = environment.getProperty("loadbalancer.client.name");
        String envTag = environment.getProperty("spring.cloud.nacos.discovery.metadata.tag");
        return new MpLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name, envTag, properties);
    }
}

