/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64Utils.class);

    private Base64Utils() {
        throw new UnsupportedOperationException("This class is not supposed to be instantiated!");
    }

    public static String encode(String str) throws BaseException {
        byte[] bytes = str.getBytes();
        byte[] encoded = Base64Utils.encode(bytes);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String encode(String str, String charset) throws BaseException {
        byte[] bytes;
        try {
            bytes = str.getBytes(charset);
        }
        catch (UnsupportedEncodingException var6) {
            throw new BaseException("Unsupported charset: " + charset, (Throwable)var6);
        }
        byte[] encoded = Base64Utils.encode(bytes);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String decode(String str) throws BaseException {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        byte[] decoded = Base64Utils.decode(bytes);
        return new String(decoded);
    }

    public static String decode(String str, String charset) throws BaseException {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        byte[] decoded = Base64Utils.decode(bytes);
        try {
            return new String(decoded, charset);
        }
        catch (UnsupportedEncodingException var5) {
            throw new BaseException("Unsupported charset: " + charset, (Throwable)var5);
        }
    }

    public static byte[] encode(byte[] bytes) throws BaseException {
        return Base64Utils.encode(bytes, 0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] encode(byte[] bytes, int wrapAt) throws BaseException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Base64Utils.encode(inputStream, outputStream, wrapAt);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException var15) {
            throw new BaseException("Unexpected I/O error", (Throwable)var15);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decode(byte[] bytes) throws BaseException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Base64Utils.decode(inputStream, outputStream);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException var14) {
            throw new BaseException("Unexpected I/O error", (Throwable)var14);
        }
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64Utils.encode(inputStream, outputStream, 0);
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int wrapAt) throws IOException {
        Base64OutputStream aux = new Base64OutputStream(outputStream, wrapAt);
        Base64Utils.copy(inputStream, aux);
        aux.commit();
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64Utils.copy(new Base64InputStream(inputStream), outputStream);
    }

    public static void encode(File source, File target, int wrapAt) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(source);
             FileOutputStream outputStream = new FileOutputStream(target);){
            Base64Utils.encode(inputStream, outputStream, wrapAt);
        }
        catch (Exception e) {
            LOGGER.error("encode error", (Throwable)e);
        }
    }

    public static void encode(File source, File target) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(source);
             FileOutputStream outputStream = new FileOutputStream(target);){
            Base64Utils.encode(inputStream, outputStream);
        }
        catch (Exception e) {
            LOGGER.error("encode error", (Throwable)e);
        }
    }

    public static void decode(File source, File target) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(source);
             FileOutputStream outputStream = new FileOutputStream(target);){
            Base64Utils.decode(inputStream, outputStream);
        }
        catch (Exception e) {
            LOGGER.error("decode error", (Throwable)e);
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] b = new byte[1024];
        while ((len = inputStream.read(b)) != -1) {
            outputStream.write(b, 0, len);
        }
    }

    static class Base64OutputStream
    extends OutputStream {
        private OutputStream outputStream = null;
        private int buffer = 0;
        private int bytecounter = 0;
        private int linecounter = 0;
        private int linelength = 0;

        public Base64OutputStream(OutputStream outputStream) {
            this(outputStream, 76);
        }

        public Base64OutputStream(OutputStream outputStream, int wrapAt) {
            this.outputStream = outputStream;
            this.linelength = wrapAt;
        }

        @Override
        public void write(int b) throws IOException {
            int value = (b & 0xFF) << 16 - this.bytecounter * 8;
            this.buffer |= value;
            ++this.bytecounter;
            if (this.bytecounter == 3) {
                this.commit();
            }
        }

        @Override
        public void close() throws IOException {
            this.commit();
            this.outputStream.close();
        }

        protected void commit() throws IOException {
            if (this.bytecounter > 0) {
                if (this.linelength > 0 && this.linecounter == this.linelength) {
                    this.outputStream.write("\r\n".getBytes());
                    this.linecounter = 0;
                }
                char b1 = Shared.chars.charAt(this.buffer << 8 >>> 26);
                char b2 = Shared.chars.charAt(this.buffer << 14 >>> 26);
                char b3 = this.bytecounter < 2 ? Shared.pad : Shared.chars.charAt(this.buffer << 20 >>> 26);
                char b4 = this.bytecounter < 3 ? Shared.pad : Shared.chars.charAt(this.buffer << 26 >>> 26);
                this.outputStream.write(b1);
                this.outputStream.write(b2);
                this.outputStream.write(b3);
                this.outputStream.write(b4);
                this.linecounter += 4;
                this.bytecounter = 0;
                this.buffer = 0;
            }
        }
    }

    static class Base64InputStream
    extends InputStream {
        private InputStream inputStream;
        private int[] buffer;
        private int bufferCounter = 0;
        private boolean eof = false;

        public Base64InputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            if (this.buffer == null || this.bufferCounter == this.buffer.length) {
                if (this.eof) {
                    return -1;
                }
                this.acquire();
                if (this.buffer.length == 0) {
                    this.buffer = null;
                    return -1;
                }
                this.bufferCounter = 0;
            }
            return this.buffer[this.bufferCounter++];
        }

        private void acquire() throws IOException {
            int l;
            char[] four = new char[4];
            int i = 0;
            do {
                int b;
                if ((b = this.inputStream.read()) == -1) {
                    if (i != 0) {
                        throw new IOException();
                    }
                    this.buffer = new int[0];
                    this.eof = true;
                    return;
                }
                char c = (char)b;
                if (Shared.chars.indexOf(c) == -1 && c != Shared.pad) {
                    if (c == '\r' || c == '\n') continue;
                    throw new IOException();
                }
                four[i++] = c;
            } while (i < 4);
            boolean padded = false;
            for (i = 0; i < 4; ++i) {
                if (four[i] != Shared.pad) {
                    if (!padded) continue;
                    throw new IOException();
                }
                if (padded) continue;
                padded = true;
            }
            if (four[3] == Shared.pad) {
                if (this.inputStream.read() != -1) {
                    throw new IOException();
                }
                this.eof = true;
                l = four[2] == Shared.pad ? 1 : 2;
            } else {
                l = 3;
            }
            int aux = 0;
            for (i = 0; i < 4; ++i) {
                if (four[i] == Shared.pad) continue;
                aux |= Shared.chars.indexOf(four[i]) << 6 * (3 - i);
            }
            this.buffer = new int[l];
            for (i = 0; i < l; ++i) {
                this.buffer[i] = aux >>> 8 * (2 - i) & 0xFF;
            }
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }

    static class Shared {
        static String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        static char pad = (char)61;

        Shared() {
        }
    }
}

