/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.core.ReflectUtils;

public class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    public static <T, X> T copyProperties(T dest, X src) {
        try {
            org.springframework.beans.BeanUtils.copyProperties(src, dest);
            return dest;
        }
        catch (Exception e) {
            LOGGER.error(" copy error ", (Throwable)e);
            throw new BaseException("00000001", "\u590d\u5236\u5bf9\u8c61\u5c5e\u6027\u51fa\u9519");
        }
    }

    public static <T, X> List<T> copyList(List<X> src, Class<T> destClass) {
        return src.stream().map(ad -> BeanUtils.copyProperties(ReflectUtils.newInstance((Class)destClass), ad)).collect(Collectors.toList());
    }

    public static <T, X> List<T> copyList(List<T> dest, List<X> src, Class<T> destClass) {
        if (null == dest) {
            return BeanUtils.copyList(src, destClass);
        }
        src.stream().map(ad -> BeanUtils.copyProperties(ReflectUtils.newInstance((Class)destClass), ad)).forEach(copy -> dest.add(copy));
        return dest;
    }

    public static <T, X> T copyProperties(T dest, X src, String ... ignoreProperties) {
        try {
            org.springframework.beans.BeanUtils.copyProperties(src, dest, (String[])ignoreProperties);
            return dest;
        }
        catch (Exception e) {
            LOGGER.error(" copy error ", (Throwable)e);
            throw new BaseException("00000001", "\u590d\u5236\u5bf9\u8c61\u5c5e\u6027\u51fa\u9519");
        }
    }

    public static <T, X> List<T> copyList(List<X> src, Class<T> destClass, String ... ignoreProperties) {
        return src.stream().map(ad -> BeanUtils.copyProperties(ReflectUtils.newInstance((Class)destClass), ad, ignoreProperties)).collect(Collectors.toList());
    }
}

