/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final String YYYMMDDHHmm = "yyyy-MM-dd HH:mm";
    private static final String YYYMMDDHHmmss = "yyyy-MM-dd HH:mm:ss";
    private static final String YYYYMMDD = "yyyy-MM-dd";
    private static final String HHmmss = "HH:mm:ss";
    private static final String YYYYMM = "yyyy-MM";

    private DateUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String formatHHmmss(Date date) {
        return DateFormatUtils.format((Date)date, (String)HHmmss);
    }

    public static String formatYYYMMDDHHmm(Date date) {
        return DateFormatUtils.format((Date)date, (String)YYYMMDDHHmm);
    }

    public static Date parseYYYMMDDHHmm(String dateStr) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])new String[]{YYYMMDDHHmm});
        }
        catch (ParseException e) {
            LOG.error("parse date error ", (Throwable)e);
            return null;
        }
    }

    public static Date parseYYYMMDD(String dateStr) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])new String[]{YYYYMMDD});
        }
        catch (ParseException e) {
            LOG.error("parse date error ", (Throwable)e);
            return null;
        }
    }

    public static Date parseYYYMM(String dateStr) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])new String[]{YYYYMM});
        }
        catch (ParseException e) {
            LOG.error("parse date error ", (Throwable)e);
            return null;
        }
    }

    public static String formatYYYMM(Date date) {
        return DateFormatUtils.format((Date)date, (String)YYYYMM);
    }

    public static String formatYYYYMMDD(Date date) {
        return DateFormatUtils.format((Date)date, (String)YYYYMMDD);
    }

    public static String formatYYYMMDDHHmmss(Date date) {
        return DateFormatUtils.format((Date)date, (String)YYYMMDDHHmmss);
    }

    public static Date parseYYYMMDDHHmmss(String dateStr) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])new String[]{YYYMMDDHHmmss});
        }
        catch (ParseException e) {
            LOG.error("parse date error ", (Throwable)e);
            return null;
        }
    }

    public static Date addDays(Date source, int nday) {
        Date dateAdd = org.apache.commons.lang3.time.DateUtils.addDays((Date)source, (int)nday);
        String dateAddStr = DateUtils.formatYYYYMMDD(dateAdd);
        return DateUtils.parseYYYMMDDHHmmss(dateAddStr + " 00:00:00");
    }

    public static boolean isValidDate(String strDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYMMDDHHmmss);
        if (strDate == null || "".equals(strDate)) {
            return false;
        }
        try {
            dateFormat.parse(strDate);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String formatDateYYYYMMDD000000(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        return DateUtils.formatYYYMMDDHHmmss(instance.getTime());
    }

    public static String formatDateYYYYMMDD235959(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(11, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        return DateUtils.formatYYYMMDDHHmmss(instance.getTime());
    }

    public static Date getYesterday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static Integer getHour() {
        Date currentDate = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(currentDate);
        return instance.get(11);
    }

    public static String someday(int yeas, int months) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.set(1, instance.get(1) - yeas);
        instance.set(2, months - 1);
        instance.set(5, 1);
        return DateUtils.formatYYYYMMDD(instance.getTime());
    }

    public static Date getMonthEnd(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date getMonthBegin(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }
}

