/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpAddressUtils.class);
    private static final Pattern IP_PATTERN = Pattern.compile("^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}$");
    private static final Pattern PRIVATE_IP_PATTERN = Pattern.compile("127\\.0\\.0\\.1");

    private IpAddressUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getIP(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && ("127.0.0.1".equals(ip = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ip))) {
            ip = IpAddressUtils.doGetLocalIp();
        }
        LOGGER.info("\u5ba2\u6237\u7aef:{}", (Object)ip);
        if (ip != null && ip.trim().length() > 0) {
            int index = ip.indexOf(44);
            ip = index != -1 ? ip.substring(0, index) : ip;
        }
        return ip;
    }

    public static boolean isIP(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        Matcher matcher = IP_PATTERN.matcher(ip);
        return matcher.matches();
    }

    public static boolean isLoopbackIP(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        Matcher matcher = PRIVATE_IP_PATTERN.matcher(ip);
        return matcher.matches();
    }

    protected static String doGetLocalIp() {
        String ip = null;
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("windows")) {
                InetAddress localHost = InetAddress.getLocalHost();
                ip = localHost.getHostAddress();
            } else {
                ip = IpAddressUtils.getLinuxIpAddress();
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.info("The LocalIpAddress (1) Is {}", (Object)ip);
        return ip;
    }

    private static String getLinuxIpAddress() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address instanceof Inet6Address || null == (ip = address.getHostAddress()) || !IpAddressUtils.isIP(ip) || !IpAddressUtils.isLoopbackIP(ip)) continue;
                    return ip;
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return ip;
    }
}

