/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String toJson(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static <T> T toObject(String jsonStr, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static <T> T toObject(String jsonStr, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, typeReference);
        }
        catch (Exception e) {
            LOGGER.error(" change json to object error ", (Throwable)e);
            throw new BaseException("00000001", "JSON\u8f6c\u6362\u9519\u8bef");
        }
    }

    public static <T> List<T> toListObject(String jsonStr, Class<T> clazz) {
        CollectionType listType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)OBJECT_MAPPER.readValue(jsonStr, (JavaType)listType);
        }
        catch (Exception e) {
            LOGGER.error(" change json to object error ", (Throwable)e);
            throw new BaseException("00000001", "JSON\u8f6c\u6362\u9519\u8bef");
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

