/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2CryptoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SM2CryptoUtil.class);
    private static final int KEY_SIZE = 1024;
    private static final String ALGORITHM = "SM2";

    private SM2CryptoUtil() {
        throw new UnsupportedOperationException();
    }

    public static PublicKey buildPublicKeyByBase64Key(String base64Key) {
        return SM2CryptoUtil.buildPublicKey(Base64.decode((String)base64Key));
    }

    public static PublicKey buildPublicKey(byte[] keyBytes) {
        return SecureUtil.generatePublicKey((String)ALGORITHM, (byte[])keyBytes);
    }

    public static PrivateKey buildPrivateKeyByBase64Key(String base64Key) {
        return SM2CryptoUtil.buildPrivateKey(Base64.decode((String)base64Key));
    }

    public static PrivateKey buildPrivateKey(byte[] keyBytes) {
        return SecureUtil.generatePrivateKey((String)ALGORITHM, (byte[])keyBytes);
    }

    public static KeyPair generateKeyPair() {
        KeyPair pair = SecureUtil.generateKeyPair((String)ALGORITHM, (int)1024);
        byte[] publicKey = pair.getPublic().getEncoded();
        String publicKeyStr = Base64.toBase64String((byte[])publicKey);
        LOGGER.info("\u516c\u94a5\uff1a{}", (Object)publicKeyStr);
        byte[] privateKey = pair.getPrivate().getEncoded();
        String privateKeyStr = Base64.toBase64String((byte[])privateKey);
        LOGGER.info("\u79c1\u94a5\uff1a{}", (Object)privateKeyStr);
        return pair;
    }

    public static String encryptBase64(String content, PublicKey publicKey) {
        if (StringUtils.isBlank((CharSequence)content) || null == publicKey) {
            return null;
        }
        SM2 sm2 = SmUtil.sm2(null, (PublicKey)publicKey);
        return sm2.encryptBase64(content.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey);
    }

    public static String encryptHex(String content, PublicKey publicKey) {
        if (StringUtils.isBlank((CharSequence)content) || null == publicKey) {
            return null;
        }
        SM2 sm2 = SmUtil.sm2(null, (PublicKey)publicKey);
        return sm2.encryptHex(content.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey);
    }

    public static String decrypt(String encryptContent, PrivateKey privateKey) {
        if (StringUtils.isBlank((CharSequence)encryptContent) || null == privateKey) {
            return null;
        }
        SM2 sm2 = SmUtil.sm2((PrivateKey)privateKey, null);
        return new String(sm2.decrypt(encryptContent, KeyType.PrivateKey), StandardCharsets.UTF_8);
    }

    public static String sign(String content, PrivateKey privateKey) {
        if (StringUtils.isBlank((CharSequence)content) || null == privateKey) {
            return null;
        }
        SM2 sm2 = SmUtil.sm2((PrivateKey)privateKey, null);
        return sm2.signHex(HexUtil.encodeHexStr((String)content));
    }

    public static boolean verify(String content, String sign, PublicKey publicKey) {
        SM2 sm2 = SmUtil.sm2(null, (PublicKey)publicKey);
        return sm2.verifyHex(HexUtil.encodeHexStr((String)content), sign);
    }
}

