/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Strings {
    private Strings() {
        throw new IllegalStateException("Utility class");
    }

    public static String underscoreName(String name) {
        StringBuilder result = new StringBuilder();
        boolean firstLetter = true;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            for (char chart : name.toCharArray()) {
                if (Character.isUpperCase(chart) && !firstLetter) {
                    result.append("_");
                }
                result.append(Character.toLowerCase(chart));
                firstLetter = false;
            }
        }
        return result.toString();
    }

    public static String camelName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(name);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(matcher.start() == 0 ? Character.toLowerCase(word.charAt(0)) : Character.toUpperCase(word.charAt(0)));
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index));
                continue;
            }
            sb.append(word.substring(1));
        }
        return sb.toString();
    }

    public static boolean isEmail(String email) {
        String regEx1;
        Pattern p;
        Matcher m;
        return StringUtils.isNotBlank((CharSequence)email) && (m = (p = Pattern.compile(regEx1 = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$")).matcher(email)).matches();
    }
}

