/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class UrlCoderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlCoderUtil.class);

    private UrlCoderUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String decoder(String value) {
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = UriUtils.decode((String)value, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            LOGGER.error("header\u89e3\u7801\u9519\u8bef, value={}", (Object)value);
        }
        return value;
    }

    public static String encoder(String value) {
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = UriUtils.encode((String)value, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            LOGGER.error("header\u7f16\u7801\u9519\u8bef, value={}", (Object)value);
        }
        return value;
    }
}

