/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.agent;

import com.cyberway.mp.bc.context.agent.mq.rabbitmq.transformer.RabbitmqConsumerTransformer;
import com.cyberway.mp.bc.context.agent.mq.rabbitmq.transformer.RabbitmqProducerTransformer;
import com.cyberway.mp.bc.context.agent.mq.rabbitmq.transformer.SpringRabbitmqListenerContainerTransformer;
import com.cyberway.mp.bc.context.agent.mq.rabbitmq.transformer.SpringRabbitmqListenerTransformer;
import com.cyberway.mp.bc.context.agent.mq.rocketmq.transformer.RocketmqConsumerTransformer;
import com.cyberway.mp.bc.context.agent.mq.rocketmq.transformer.RocketmqProducerTransformer;
import com.cyberway.mp.bc.context.agent.mq.servicebus.transformer.JmsServiceBusConsumerTransformer;
import com.cyberway.mp.bc.context.agent.mq.servicebus.transformer.JmsServiceBusProducerTransformer;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ContextAgent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ContextAgent INSTANCE = new ContextAgent();
    private static final String RABBITMQ_PRODUCER_CLASS = "com.rabbitmq.client.impl.ChannelN";
    private static final String RABBITMQ_CONSUMER_CLASS = "com.rabbitmq.client.Consumer";
    private static final String RABBITMQ_LISTENER_CLASS = "org.springframework.amqp.core.MessageListener";
    private static final String ROCKETMQ_PRODUCER_CLASS = "org.apache.rocketmq.client.impl.MQClientAPIImpl";
    private static final String ROCKETMQ_CONSUMER_CLASS = "org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently";
    private static final String JMS_SERVICE_BUS_SENDER_CLASS = "org.apache.qpid.jms.JmsSession";
    private static final String JMS_SERVICE_BUS_LISTENER_CLASS = "org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter";
    private static final List<String> AGENT_CLASS_LIST = Arrays.asList("com.rabbitmq.client.impl.ChannelN", "com.rabbitmq.client.Consumer", "org.springframework.amqp.core.MessageListener", "org.apache.rocketmq.client.impl.MQClientAPIImpl", "org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently", "org.apache.qpid.jms.JmsSession", "org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter");
    private volatile boolean hasInit = false;

    private ContextAgent() {
    }

    public static ContextAgent getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() {
        ContextAgent contextAgent = INSTANCE;
        synchronized (contextAgent) {
            if (!this.hasInit) {
                this.logger.info("\u521d\u59cb\u5316\u4e0a\u4e0b\u6587agent\u63d2\u4ef6");
                ByteBuddyAgent.install();
                AgentBuilder.Identified.Extendable agentBuilder = new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.named((String)RABBITMQ_PRODUCER_CLASS)).transform((AgentBuilder.Transformer)new RabbitmqProducerTransformer()).type((ElementMatcher)ElementMatchers.named((String)JMS_SERVICE_BUS_SENDER_CLASS)).transform((AgentBuilder.Transformer)new JmsServiceBusProducerTransformer()).type((ElementMatcher)ElementMatchers.named((String)JMS_SERVICE_BUS_LISTENER_CLASS)).transform((AgentBuilder.Transformer)new JmsServiceBusConsumerTransformer()).type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)RABBITMQ_CONSUMER_CLASS)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()))).transform((AgentBuilder.Transformer)new RabbitmqConsumerTransformer()).type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)RABBITMQ_LISTENER_CLASS)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()))).transform((AgentBuilder.Transformer)new SpringRabbitmqListenerTransformer());
                if (ClassUtils.isPresent((String)"org.apache.skywalking.apm.agent.core.context.trace.SpanLayer", null)) {
                    agentBuilder.type((ElementMatcher)ElementMatchers.named((String)"org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer")).transform((AgentBuilder.Transformer)new SpringRabbitmqListenerContainerTransformer());
                }
                agentBuilder.type((ElementMatcher)ElementMatchers.named((String)ROCKETMQ_PRODUCER_CLASS)).transform((AgentBuilder.Transformer)new RocketmqProducerTransformer()).type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)ROCKETMQ_CONSUMER_CLASS)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()))).transform((AgentBuilder.Transformer)new RocketmqConsumerTransformer()).with(AgentBuilder.RedefinitionStrategy.REDEFINITION).with((AgentBuilder.Listener)new ContextAgentListener(AGENT_CLASS_LIST)).installOnByteBuddyAgent();
                this.hasInit = true;
            }
        }
    }

    public class ContextAgentListener
    implements AgentBuilder.Listener {
        public final List<String> classList;

        public ContextAgentListener(List<String> classList) {
            this.classList = classList;
        }

        public void onDiscovery(String s, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
            ContextAgent.this.logger.debug("\u4e0a\u4e0b\u6587agent\u63d2\u4ef6-onTransformation-className={}", (Object)typeDescription.getName());
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onError(String s, ClassLoader classLoader, JavaModule javaModule, boolean b, Throwable throwable) {
            if (this.classList.contains(s)) {
                ContextAgent.this.logger.error("\u4e0a\u4e0b\u6587agent\u63d2\u4ef6 error, message={}", (Object)throwable.getMessage(), (Object)throwable);
            }
        }

        public void onComplete(String s, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }
    }
}

