/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.agent.common.plugin;

import com.cyberway.mp.bc.context.agent.common.bind.OverrideCallable;
import com.cyberway.mp.bc.context.agent.common.interceptor.AroundInterceptor;
import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.BindingPriority;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideArgsPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public final AroundInterceptor aroundInterceptor;

    public OverrideArgsPlugin(AroundInterceptor aroundInterceptor) {
        this.aroundInterceptor = aroundInterceptor;
    }

    @RuntimeType
    @BindingPriority(value=1)
    public Object intercept(@This Object obj, @AllArguments Object[] allArguments, @Morph OverrideCallable callable, @Origin Method method) throws Throwable {
        try {
            this.aroundInterceptor.beforeMethod(obj, method, allArguments, null);
        }
        catch (Throwable throwable) {
            this.logger.error("class[{}] before method[{}] intercept failure", obj.getClass(), (Object)method.getName());
        }
        Object ret = null;
        try {
            ret = callable.call(allArguments);
        }
        catch (Throwable throwable) {
            try {
                this.aroundInterceptor.handleMethodException(obj, method, allArguments, throwable);
            }
            catch (Throwable t) {
                this.logger.error("class[{}] handleMethodException method[{}] intercept failure", obj.getClass(), (Object)method.getName());
            }
            throw throwable;
        }
        finally {
            try {
                this.aroundInterceptor.afterMethod(obj, method, allArguments, ret);
            }
            catch (Throwable throwable) {
                this.logger.error("class[{}] afterMethod method[{}] intercept failure", obj.getClass(), (Object)method.getName());
            }
        }
        return ret;
    }
}

