/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.agent.mq.rabbitmq.interceptor;

import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.agent.common.interceptor.AroundInterceptor;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class SpringRabbitmqListenerContainerInterceptor
implements AroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "RabbitMQ/";
    public static final String CONSUMER_OPERATE_NAME_SUFFIX = "/Consumer/invoke/";

    @Override
    public void beforeMethod(Object object, Method method, Object[] allArguments, Object result) {
        ContextCarrier contextCarrier = new ContextCarrier();
        Connection connection = ((Channel)allArguments[0]).getConnection();
        String url = connection.getAddress().toString().replace("/", "") + ":" + connection.getPort();
        Message message = (Message)allArguments[1];
        MessageProperties msgProperties = message.getMessageProperties();
        String msgTopic = msgProperties.getConsumerQueue();
        AbstractSpan activeSpan = ContextManager.createEntrySpan((String)("RabbitMQ/Queue/" + msgTopic + CONSUMER_OPERATE_NAME_SUFFIX), null).start(System.currentTimeMillis());
        Tags.MQ_BROKER.set(activeSpan, url);
        Tags.MQ_TOPIC.set(activeSpan, msgProperties.getReceivedExchange());
        Tags.MQ_QUEUE.set(activeSpan, msgProperties.getConsumerQueue());
        activeSpan.setComponent((Component)ComponentsDefine.RABBITMQ_CONSUMER);
        SpanLayer.asMQ((AbstractSpan)activeSpan);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            if (msgProperties.getHeaders() == null || msgProperties.getHeaders().get(next.getHeadKey()) == null) continue;
            String decodeVal = UrlCoderUtil.decoder(msgProperties.getHeaders().get(next.getHeadKey()).toString());
            next.setHeadValue(decodeVal);
        }
        ContextManager.extract((ContextCarrier)contextCarrier);
    }

    @Override
    public Object afterMethod(Object object, Method method, Object[] allArguments, Object result) {
        ContextManager.stopSpan();
        return result;
    }

    @Override
    public void handleMethodException(Object object, Method method, Object[] allArguments, Throwable throwable) {
        ContextManager.activeSpan().log(throwable);
    }
}

