/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.agent.mq.servicebus;

import cn.hutool.core.util.HexUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.qpid.jms.message.JmsMessagePropertySupport;

public class JmsMessagePropertyKeyUtils {
    private static final String KEY_PREFIX = "HexKey$";

    private JmsMessagePropertyKeyUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String encode(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return key;
        }
        try {
            JmsMessagePropertySupport.checkPropertyNameIsValid((String)key, (boolean)true);
        }
        catch (Exception e) {
            key = KEY_PREFIX + HexUtil.encodeHexStr((String)key, (Charset)StandardCharsets.UTF_8);
        }
        return key;
    }

    public static String decode(String key) {
        if (StringUtils.isBlank((CharSequence)key) || !key.startsWith(KEY_PREFIX)) {
            return null;
        }
        return HexUtil.decodeHexStr((String)key.substring(KEY_PREFIX.length()), (Charset)StandardCharsets.UTF_8);
    }
}

