/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.agent.mq.servicebus.interceptor;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.agent.common.interceptor.AroundInterceptor;
import com.cyberway.mp.bc.context.agent.mq.servicebus.JmsMessagePropertyKeyUtils;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsServiceBusConsumerInterceptor
implements AroundInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void beforeMethod(Object object, Method method, Object[] allArguments, Object result) throws Throwable {
        if (null != allArguments) {
            try {
                for (Object argument : allArguments) {
                    if (!Message.class.isAssignableFrom(argument.getClass())) continue;
                    this.logger.debug("Message Property\u8bbe\u7f6e\u5230\u4e0a\u4e0b\u6587\u4e2d");
                    Message message = (Message)argument;
                    this.setMessagePropertiesToContext(message);
                    break;
                }
            }
            catch (Exception e) {
                this.logger.error("Message Property\u8bbe\u7f6e\u5230\u4e0a\u4e0b\u6587\u4e2d\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void setMessagePropertiesToContext(Message message) throws JMSException {
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            String decodeKey = JmsMessagePropertyKeyUtils.decode(key);
            Object objectProperty = message.getObjectProperty(key);
            if (null == objectProperty) continue;
            if (StringUtils.isNotBlank((CharSequence)decodeKey) && this.enableContextKey(decodeKey)) {
                ServiceContext.getContext().setAttachment(decodeKey, UrlCoderUtil.decoder(objectProperty.toString()));
                continue;
            }
            if (!this.enableContextKey(key)) continue;
            ServiceContext.getContext().setAttachment(key, UrlCoderUtil.decoder(objectProperty.toString()));
        }
    }

    @Override
    public Object afterMethod(Object object, Method method, Object[] allArguments, Object result) throws Throwable {
        ServiceContext.removeContext();
        return result;
    }

    @Override
    public void handleMethodException(Object object, Method method, Object[] allArguments, Throwable throwable) {
        ServiceContext.removeContext();
    }
}

