/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.agent.mq.servicebus.interceptor;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.agent.common.interceptor.AroundInterceptor;
import com.cyberway.mp.bc.context.agent.mq.servicebus.JmsMessagePropertyKeyUtils;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsServiceBusProducerInterceptor
implements AroundInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void beforeMethod(Object object, Method method, Object[] allArguments, Object result) throws Throwable {
        if (null != allArguments) {
            try {
                for (Object argument : allArguments) {
                    if (!Message.class.isAssignableFrom(argument.getClass())) continue;
                    this.logger.debug("\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u5230Message Property\u4e2d");
                    Message message = (Message)argument;
                    this.setContextToMessageProperties(message);
                    break;
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u5230Message Property\u4e2d\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void setContextToMessageProperties(Message message) throws JMSException {
        Map<String, Object> attachments = ServiceContext.getContext().getKeys();
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            if (!this.enableContextKey(entry.getKey()) || null == entry.getValue()) continue;
            message.setStringProperty(JmsMessagePropertyKeyUtils.encode(entry.getKey()), UrlCoderUtil.encoder(entry.getValue().toString()));
        }
    }

    @Override
    public Object afterMethod(Object object, Method method, Object[] allArguments, Object result) throws Throwable {
        return result;
    }

    @Override
    public void handleMethodException(Object object, Method method, Object[] allArguments, Throwable throwable) {
    }
}

