/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.autoconfigure;

import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import com.cyberway.mp.bc.context.intercepter.feign.FeignContextAssembleIntercepter;
import com.cyberway.mp.bc.context.intercepter.feign.FeignContextParseInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="feign.context", name={"isEnable"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={WebMvcConfigurer.class})
@Import(value={ContextProperties.class})
public class FeignContextAutoConfiguration
implements WebMvcConfigurer {
    private final ContextProperties contextProperties;

    public FeignContextAutoConfiguration(ContextProperties contextProperties) {
        this.contextProperties = contextProperties;
    }

    @Bean
    public FeignContextAssembleIntercepter feignFilter(ContextProperties contextProperties) {
        return new FeignContextAssembleIntercepter(contextProperties);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new FeignContextParseInterceptor(this.contextProperties));
    }
}

