/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.intercepter.feign;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnClass(value={RequestInterceptor.class})
@ConditionalOnProperty(prefix="feign.context", name={"isEnable"}, havingValue="true", matchIfMissing=true)
public class FeignContextAssembleIntercepter
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignContextAssembleIntercepter.class);
    private final Set<String> needEncodeSet = new HashSet<String>();

    public FeignContextAssembleIntercepter(ContextProperties contextProperties) {
        if (null != contextProperties.getHeader() && null != contextProperties.getHeader().getNeedEncode()) {
            this.needEncodeSet.addAll(contextProperties.getHeader().getNeedEncode());
        }
    }

    public void apply(RequestTemplate requestTemplate) {
        try {
            Map<String, Object> attachments = ServiceContext.getContext().getKeys();
            attachments.forEach((headerName, headerValue) -> {
                if (!(headerName.startsWith("accept") || headerName.startsWith("Accept") || headerName.startsWith("content") || headerName.startsWith("Content") || headerName.startsWith("x-forwarded-for") || headerName.equals("host") || headerName.equals("Host") || headerName.equals("origin") || headerName.equals("Origin") || !this.isBaseType(headerValue))) {
                    try {
                        requestTemplate.header(headerName, new String[]{this.checkNeedEncode((String)headerName) ? UrlCoderUtil.encoder(headerValue.toString()) : headerValue.toString()});
                    }
                    catch (Exception e) {
                        log.error("\u5934\u4fe1\u606f\u6dfb\u52a0\u5f02\u5e38| e: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u6dfb\u52a0\u5230\u4e0a\u4e0b\u6587\u5f02\u5e38| e: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isBaseType(Object headerValue) {
        return headerValue instanceof String || headerValue instanceof Integer || headerValue instanceof Long || headerValue instanceof Float || headerValue instanceof Double || headerValue instanceof Boolean;
    }

    private boolean checkNeedEncode(String headerName) {
        for (String needEncodeHeader : this.needEncodeSet) {
            if (!needEncodeHeader.equalsIgnoreCase(headerName)) continue;
            return true;
        }
        return false;
    }
}

