/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.context.intercepter.feign;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;

@Order(value=0x7FFFFFFF)
@ConditionalOnProperty(prefix="feign.context", name={"isEnable"}, havingValue="true")
public class FeignContextParseInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(FeignContextParseInterceptor.class);
    private final Set<String> needDecodeSet = new HashSet<String>();

    public FeignContextParseInterceptor(ContextProperties contextProperties) {
        if (null != contextProperties.getHeader() && null != contextProperties.getHeader().getNeedDecode()) {
            this.needDecodeSet.addAll(contextProperties.getHeader().getNeedDecode());
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = this.getHttpHeaderValue(request, headerName);
                ServiceContext.getContext().setAttachment(headerName, headerValue);
            }
        }
        catch (Exception var6) {
            logger.error(var6.getMessage(), (Throwable)var6);
        }
        return true;
    }

    private String getHttpHeaderValue(HttpServletRequest httpServletRequest, String headerName) {
        String value = httpServletRequest.getHeader(headerName);
        return this.checkNeedDecode(headerName) ? UrlCoderUtil.decoder(value) : value;
    }

    private boolean checkNeedDecode(String headerName) {
        for (String needDecodeHeader : this.needDecodeSet) {
            if (!needDecodeHeader.equalsIgnoreCase(headerName)) continue;
            return true;
        }
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ServiceContext.removeContext();
    }
}

