/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal;

import com.cyberway.mp.bc.dal.config.DALProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class DbBatchOperatorAspect {
    private final DALProperties dbProperties;

    public DbBatchOperatorAspect(DALProperties dbProperties) {
        this.dbProperties = dbProperties;
    }

    @Pointcut(value="execution(* com.cyberway.mp.bc.dal.GenericMapper.batchInsert(..))|| execution(* com.cyberway.mp.bc.dal.GenericMapper.batchUpdate(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        if (null != args && args.length == 1 && args[0] instanceof Collection) {
            Collection param = (Collection)args[0];
            if (!param.isEmpty()) {
                List partition = ListUtils.partition(new ArrayList(param), (int)this.dbProperties.getBatchSize());
                for (List list : partition) {
                    Object[] partitionArgs = new Object[]{list};
                    point.proceed(partitionArgs);
                }
            }
            return null;
        }
        return point.proceed();
    }
}

