/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.generate.InterceptSqlGenerator;
import com.cyberway.mp.bc.dal.generate.InterceptSqlSource;
import com.cyberway.mp.bc.dal.generate.SqlGeneratorFactory;
import com.cyberway.mp.bc.dal.model.BusinessEntity;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithTenant;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.dal.util.IdWorker;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class GenericMapperInterceptor
implements Interceptor {
    private final SqlGeneratorFactory sqlGeneratorFactory;
    private final IdWorker idWorker;

    public GenericMapperInterceptor(SqlGeneratorFactory sqlGeneratorFactory, IdWorker idWorker) {
        this.sqlGeneratorFactory = sqlGeneratorFactory;
        this.idWorker = idWorker;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        Object parameter = invocation.getArgs()[1];
        String id = ms.getId();
        String methodName = id.substring(id.lastIndexOf(".") + 1);
        if (ms.getSqlSource() instanceof InterceptSqlSource) {
            this.setCommonFiledIfNeed(parameter, ms.getSqlCommandType());
            InterceptSqlGenerator generator = this.sqlGeneratorFactory.findWhenIntercept(methodName);
            InterceptSqlSource interceptSqlSource = (InterceptSqlSource)ms.getSqlSource();
            if (generator != null) {
                SqlCommand newSql = generator.merge(interceptSqlSource.getMethod(), interceptSqlSource.getMapper(), parameter, interceptSqlSource.getSqlFrame());
                SqlSource sqlSource = this.buildSqlSource(methodName, ms.getParameterMap(), ms.getConfiguration(), newSql.getSql());
                this.replaceSaveAndUpdateByIdParameterMappings(methodName, ms.getParameterMap(), sqlSource.getBoundSql(parameter));
                invocation.getArgs()[0] = this.buildNewMappedStatement(ms, sqlSource, newSql.getCommandType().equals((Object)SqlCommandType.UPDATE));
            }
        }
        return invocation.proceed();
    }

    private void replaceSaveAndUpdateByIdParameterMappings(String methodName, ParameterMap parameterMap, BoundSql boundSql) {
        List currentParameterMappings;
        if (("save".equals(methodName) || "updateById".equals(methodName) || methodName.startsWith("updateBy")) && null != (currentParameterMappings = boundSql.getParameterMappings()) && null != parameterMap) {
            Map<String, ParameterMapping> parameterMappingMap = parameterMap.getParameterMappings().stream().collect(Collectors.toMap(ParameterMapping::getProperty, p -> p));
            ListIterator<ParameterMapping> iterator = currentParameterMappings.listIterator();
            while (iterator.hasNext()) {
                ParameterMapping next = (ParameterMapping)iterator.next();
                if (!parameterMappingMap.containsKey(next.getProperty())) continue;
                iterator.remove();
                iterator.add(parameterMappingMap.remove(next.getProperty()));
            }
        }
    }

    private void setCommonFiledIfNeed(Object parameter, SqlCommandType sqlType) {
        if (null == parameter) {
            return;
        }
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            this.handleMap(map, sqlType);
        } else {
            this.setCommonField(parameter, sqlType);
        }
    }

    private void setCommonField(Object parameter, SqlCommandType sqlType) {
        if (null == parameter) {
            return;
        }
        Class<?> clazz = parameter.getClass();
        if (BusinessEntityWithAppInstance.class.isAssignableFrom(clazz)) {
            this.setBusinessEntityWithAppInstanceField(parameter, sqlType, clazz);
        } else if (BusinessEntityWithTenant.class.isAssignableFrom(clazz)) {
            this.setBusinessEntityWithTenantField(parameter, sqlType, clazz);
        } else if (BusinessEntity.class.isAssignableFrom(clazz)) {
            this.setBusinessEntityField(parameter, sqlType, clazz);
        } else if (Entity.class.isAssignableFrom(clazz) && SqlCommandType.INSERT == sqlType) {
            this.setIdField(parameter, clazz);
        }
    }

    private void setIdField(Object arg, Class<?> argClass) {
        Field field = FieldUtils.getField(argClass, (String)"id", (boolean)true);
        try {
            if (field.get(arg) == null) {
                Long id = this.idWorker.nextId();
                field.set(arg, id);
            }
        }
        catch (Exception e) {
            throw new BaseException("00000001", "\u8bbe\u7f6eID\u503c\u5f02\u5e38");
        }
    }

    private void setBusinessEntityField(Object arg, SqlCommandType sqlType, Class<?> argClass) {
        Date currentDate = new Date();
        ServiceContext context = ServiceContext.getContext();
        Long requestUserId = context == null ? Long.valueOf(0L) : (Long)ObjectUtils.defaultIfNull((Object)context.getRequestUserId(), (Object)0L);
        String requestUserName = context == null ? "" : StringUtils.defaultString((String)context.getRequestUserName());
        this.setCommonField(arg, argClass, "lastModifiedUserId", requestUserId, true);
        this.setCommonField(arg, argClass, "lastModifiedUserName", requestUserName, true);
        this.setCommonField(arg, argClass, "lastModifiedTime", currentDate, true);
        if (SqlCommandType.INSERT == sqlType) {
            this.setIdField(arg, argClass);
            this.setCommonField(arg, argClass, "createdUserId", requestUserId, false);
            this.setCommonField(arg, argClass, "createdUserName", requestUserName, false);
            this.setCommonField(arg, argClass, "createdTime", currentDate, false);
        }
    }

    private void setBusinessEntityWithTenantField(Object arg, SqlCommandType sqlType, Class<?> argClass) {
        this.setBusinessEntityField(arg, sqlType, argClass);
        if (SqlCommandType.INSERT == sqlType) {
            this.setCommonField(arg, argClass, "tenantId", ServiceContext.getContext().getRequestTenantId(), false);
        }
    }

    private void setBusinessEntityWithAppInstanceField(Object arg, SqlCommandType sqlType, Class<?> argClass) {
        this.setBusinessEntityWithTenantField(arg, sqlType, argClass);
        if (SqlCommandType.INSERT == sqlType) {
            this.setCommonField(arg, argClass, "businessZoneId", ServiceContext.getContext().getRequestBusinessZoneId(), false);
            this.setCommonField(arg, argClass, "appInstanceId", ServiceContext.getContext().getRequestAppInstanceId(), false);
        }
    }

    private void setCommonField(Object arg, Class<?> argClass, String fieldName, Object fieldValue, boolean overwrite) {
        Field field = FieldUtils.getField(argClass, (String)fieldName, (boolean)true);
        try {
            if (overwrite || field.get(arg) == null) {
                field.set(arg, fieldValue);
            }
        }
        catch (Exception e) {
            throw new BaseException("00000001", "\u8bbe\u7f6e" + fieldName + "\u503c\u5f02\u5e38");
        }
    }

    private void handleMap(Map<?, ?> map, SqlCommandType sqlType) {
        if (!map.isEmpty()) {
            Collection<?> list = map.values();
            Iterator<?> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                this.handleCollections(iterator, sqlType);
            }
        }
    }

    private void handleCollections(Iterator<?> iterator, SqlCommandType sqlType) {
        Object obj = iterator.next();
        if (!(obj instanceof Collection)) {
            this.setCommonField(obj, sqlType);
        } else {
            Collection entityList = (Collection)obj;
            if (!CollectionUtils.isEmpty((Collection)entityList)) {
                for (Object entity : entityList) {
                    this.setCommonField(entity, sqlType);
                }
            }
        }
    }

    private SqlSource buildSqlSource(String methodName, ParameterMap parameterMap, Configuration configuration, String newSql) {
        if ("batchInsert".equals(methodName) && newSql.startsWith("<script>")) {
            for (ParameterMapping parameterMapping : parameterMap.getParameterMappings()) {
                newSql = newSql.replace("item." + parameterMapping.getProperty(), "item." + parameterMapping.getProperty() + ",typeHandler=" + parameterMapping.getTypeHandler().getClass().getName());
            }
        }
        return configuration.getDefaultScriptingLanguageInstance().createSqlSource(configuration, newSql, MapperMethod.ParamMap.class);
    }

    private MappedStatement buildNewMappedStatement(MappedStatement oldMappedStatement, SqlSource sqlSource, boolean isUpdate) {
        KeyGenerator keyGenerator = oldMappedStatement.getKeyGenerator();
        if (isUpdate) {
            keyGenerator = NoKeyGenerator.INSTANCE;
        }
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(oldMappedStatement.getConfiguration(), oldMappedStatement.getId(), sqlSource, oldMappedStatement.getSqlCommandType()).parameterMap(oldMappedStatement.getParameterMap()).resource(oldMappedStatement.getResource()).fetchSize(oldMappedStatement.getFetchSize()).timeout(oldMappedStatement.getTimeout()).statementType(oldMappedStatement.getStatementType()).keyGenerator(keyGenerator).keyProperty(this.toConbimeString(oldMappedStatement.getKeyProperties())).keyColumn(this.toConbimeString(oldMappedStatement.getKeyColumns())).databaseId(oldMappedStatement.getDatabaseId()).lang(oldMappedStatement.getLang()).resultOrdered(oldMappedStatement.isResultOrdered()).resultSets(this.toConbimeString(oldMappedStatement.getResultSets())).resultMaps(oldMappedStatement.getResultMaps()).resultSetType(oldMappedStatement.getResultSetType()).flushCacheRequired(oldMappedStatement.isFlushCacheRequired()).useCache(oldMappedStatement.isUseCache()).cache(oldMappedStatement.getCache());
        return statementBuilder.build();
    }

    private String toConbimeString(String[] strArray) {
        if (strArray == null || strArray.length <= 0) {
            return "";
        }
        return String.join((CharSequence)",", strArray);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

