/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal;

import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.config.LogicDeletedMetaHolder;
import com.cyberway.mp.bc.dal.generate.DeletedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class LogicDeleteSelectVisitor
extends SelectVisitorAdapter {
    private boolean modified = false;

    public void visit(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        Map<String, Table> tableMap = this.acceptFromItem(fromItem);
        List joinList = plainSelect.getJoins();
        if (!CollectionUtils.isEmpty((Collection)joinList)) {
            for (Join join : plainSelect.getJoins()) {
                this.visitJoin(join);
            }
        }
        Expression whereExpression = plainSelect.getWhere();
        this.checkExpression(whereExpression);
        List<Expression> expressionList = this.buildExpressionByTable(tableMap);
        if (!expressionList.isEmpty()) {
            if (null != whereExpression) {
                AndExpression andExpression = new AndExpression(whereExpression, expressionList.get(0));
                for (int i = 1; i < expressionList.size(); ++i) {
                    andExpression = new AndExpression((Expression)andExpression, expressionList.get(i));
                }
                plainSelect.setWhere((Expression)andExpression);
            } else {
                Expression expression = expressionList.get(0);
                for (int i = 1; i < expressionList.size(); ++i) {
                    expression = new AndExpression(expression, expressionList.get(i));
                }
                plainSelect.setWhere(expression);
            }
        }
    }

    private List<Expression> buildExpressionByTable(Map<String, Table> tableMap) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Map.Entry<String, Table> entry : tableMap.entrySet()) {
            LogicDelete logicDelete = LogicDeletedMetaHolder.getLogicDeleteMeta(entry.getKey());
            Table table = entry.getValue();
            String tableAlias = null == table.getAlias() ? "" : table.getAlias().toString().trim();
            Parenthesis parenthesis = new Parenthesis();
            parenthesis.withExpression((Expression)new EqualsTo((Expression)this.buildColumn(tableAlias, logicDelete), (Expression)new LongValue((long)DeletedValue.NOT_DELETED.getDeleteValue())));
            expressionList.add((Expression)parenthesis);
            this.modified = true;
        }
        return expressionList;
    }

    private void checkExpression(Expression expression) {
        if (expression instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)expression;
            Expression left = andExpression.getLeftExpression();
            Expression right = andExpression.getRightExpression();
            this.checkExpression(left);
            this.checkExpression(right);
        } else if (expression instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)expression;
            Expression left = orExpression.getLeftExpression();
            Expression right = orExpression.getRightExpression();
            this.checkExpression(left);
            this.checkExpression(right);
        } else if (expression instanceof ExistsExpression) {
            ExistsExpression existsExpression = (ExistsExpression)expression;
            Expression right = existsExpression.getRightExpression();
            this.checkExpression(right);
        } else if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            Expression left = inExpression.getLeftExpression();
            Expression right = inExpression.getRightExpression();
            this.checkExpression(left);
            this.checkExpression(right);
        } else if (expression instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)expression;
            this.visit(parenthesedSelect.getPlainSelect());
        }
    }

    private Map<String, Table> acceptFromItem(FromItem fromItem) {
        Table table;
        String tableName;
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        if (fromItem instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
            parenthesedSelect.accept((SelectVisitor)this);
        } else if (fromItem instanceof ParenthesedFromItem) {
            ParenthesedFromItem parenthesedFromItem = (ParenthesedFromItem)fromItem;
            this.handleParenthesedFromItem(parenthesedFromItem);
        } else if (fromItem instanceof Table && LogicDeletedMetaHolder.getLogicDeleteMeta(tableName = (table = (Table)fromItem).getName()) != null) {
            tableMap.put(tableName, table);
        }
        return tableMap;
    }

    private void handleParenthesedFromItem(ParenthesedFromItem parenthesedFromItem) {
        List joinList;
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        FromItem fromItem = parenthesedFromItem.getFromItem();
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            tableMap.put(table.getName(), table);
        }
        if (!CollectionUtils.isEmpty((Collection)(joinList = parenthesedFromItem.getJoins()))) {
            Join join = (Join)joinList.get(0);
            Collection onExpressions = join.getOnExpressions();
            List<Expression> expressionList = this.buildExpressionByTable(tableMap);
            this.handleOnExpressions(join, onExpressions, expressionList);
        }
        for (Join join : joinList) {
            this.visitJoin(join);
        }
    }

    private void handleOnExpressions(Join join, Collection<Expression> onExpressions, List<Expression> expressionList) {
        if (!CollectionUtils.isEmpty(onExpressions)) {
            ArrayList<Expression> tempOnExpressionsList = new ArrayList<Expression>(onExpressions);
            Expression lastExpression = (Expression)tempOnExpressionsList.remove(tempOnExpressionsList.size() - 1);
            AndExpression andExpression = new AndExpression(lastExpression, expressionList.get(0));
            for (int i = 1; i < expressionList.size(); ++i) {
                andExpression = new AndExpression((Expression)andExpression, expressionList.get(i));
            }
            tempOnExpressionsList.add((Expression)andExpression);
            join.setOnExpressions(tempOnExpressionsList);
        } else {
            Expression expression = expressionList.get(0);
            for (int i = 1; i < expressionList.size(); ++i) {
                expression = new AndExpression(expression, expressionList.get(i));
            }
            join.setOnExpressions(Collections.singletonList(expression));
        }
    }

    private void visitJoin(Join join) {
        FromItem joinFromItem = join.getRightItem();
        Map<String, Table> tableMap = this.acceptFromItem(joinFromItem);
        Collection onExpressions = join.getOnExpressions();
        List<Expression> expressionList = this.buildExpressionByTable(tableMap);
        if (!expressionList.isEmpty()) {
            this.handleOnExpressions(join, onExpressions, expressionList);
        }
    }

    private Column buildColumn(String alise, LogicDelete logicDelete) {
        return new Column((String)(StringUtils.isBlank((CharSequence)alise) ? logicDelete.fieldName() : alise + "." + logicDelete.fieldName()));
    }

    public boolean isModified() {
        return this.modified;
    }
}

