/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal;

import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.ColumnType;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.ResultBeanAlias;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.generate.InterceptSqlSource;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.Case;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.TypeDiscriminator;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.FetchType;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public class MappedStatementBuilder {
    private static final Logger log = LoggerFactory.getLogger(MappedStatementBuilder.class);
    private final Set<Class<? extends Annotation>> sqlAnnotationTypes = new HashSet<Class<? extends Annotation>>();
    private final Set<Class<? extends Annotation>> sqlProviderAnnotationTypes = new HashSet<Class<? extends Annotation>>();
    private final Class<?> type;
    private final Configuration configuration;
    private final MapperBuilderAssistant assistant;

    public MappedStatementBuilder(Configuration configuration, Class<?> type, MapperBuilderAssistant assistant) {
        this.type = type;
        this.configuration = configuration;
        this.assistant = assistant;
        this.sqlAnnotationTypes.add(Select.class);
        this.sqlAnnotationTypes.add(Insert.class);
        this.sqlAnnotationTypes.add(Update.class);
        this.sqlAnnotationTypes.add(Delete.class);
        this.sqlProviderAnnotationTypes.add(SelectProvider.class);
        this.sqlProviderAnnotationTypes.add(InsertProvider.class);
        this.sqlProviderAnnotationTypes.add(UpdateProvider.class);
        this.sqlProviderAnnotationTypes.add(DeleteProvider.class);
    }

    private Class<?> getParameterType(Method method, Class<?> mapper) {
        Class<MapperMethod.ParamMap> parameterType = null;
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i, i + 1);
            Class<MapperMethod.ParamMap> currentParameterType = methodParameter.withContainingClass(mapper).getParameterType();
            if (RowBounds.class.isAssignableFrom(currentParameterType) || ResultHandler.class.isAssignableFrom(currentParameterType)) {
                return null;
            }
            parameterType = parameterType == null ? currentParameterType : MapperMethod.ParamMap.class;
        }
        return parameterType;
    }

    public void buildStatement(Class<?> mapper, Method method, Configuration configuration, String mappedStatementId, SqlCommand sqlCommand) {
        NoKeyGenerator keyGenerator;
        Class<?> parameterTypeClass = this.getParameterType(method, mapper);
        XMLLanguageDriver languageDriver = new XMLLanguageDriver();
        SqlSource sqlSource = this.getSqlSourceFromAnnotations(method, mapper, sqlCommand, configuration, parameterTypeClass, (LanguageDriver)languageDriver);
        Integer fetchSize = null;
        Integer timeout = null;
        Options options = method.getAnnotation(Options.class);
        SqlCommandType sqlCommandType = sqlCommand.getCommandType();
        boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
        ResultSetType resultSetType = ResultSetType.FORWARD_ONLY;
        boolean flushCache = !isSelect;
        boolean useCache = isSelect;
        String keyProperty = "id";
        String keyColumn = null;
        String parameterMapName = null;
        if (SqlCommandType.INSERT.equals((Object)sqlCommandType) || SqlCommandType.UPDATE.equals((Object)sqlCommandType)) {
            if (options == null) {
                keyGenerator = configuration.isUseGeneratedKeys() ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE;
            } else {
                keyGenerator = options.useGeneratedKeys() ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE;
                keyProperty = options.keyProperty();
                keyColumn = options.keyColumn();
            }
            parameterMapName = this.applyParametersTypeHandler(method, mapper, mappedStatementId);
        } else {
            keyGenerator = NoKeyGenerator.INSTANCE;
        }
        String resultMapId = null;
        ResultMap resultMapAnnotation = method.getAnnotation(ResultMap.class);
        if (resultMapAnnotation == null) {
            if (isSelect) {
                resultMapId = this.parseResultMap(method, mapper);
            }
        } else {
            String[] resultMaps = resultMapAnnotation.value();
            StringBuilder stringBuilder = new StringBuilder();
            for (String resultMap : resultMaps) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(resultMap);
            }
            resultMapId = stringBuilder.toString();
        }
        this.assistant.addMappedStatement(mappedStatementId, sqlSource, StatementType.PREPARED, sqlCommandType, fetchSize, timeout, parameterMapName, parameterTypeClass, resultMapId, this.getReturnType(method), resultSetType, flushCache, useCache, false, (KeyGenerator)keyGenerator, keyProperty, keyColumn, (String)null, (LanguageDriver)languageDriver, options != null ? this.nullOrEmpty(options.resultSets()) : null);
    }

    private String applyParametersTypeHandler(Method method, Class<?> mapperClass, String mappedStatementId) {
        Class<?> entityClass;
        if (null != method && null != mapperClass && null != (entityClass = this.getEntityClass(mapperClass))) {
            ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
            List<Field> fields = EntityUtils.getEntityNotStaticFields(entityClass);
            for (Field field : fields) {
                Class<TypeHandler<?>> typeHandler;
                IgnoreField ignoreField = field.getAnnotation(IgnoreField.class);
                if (ignoreField != null) continue;
                Object property = field.getName();
                if ("updateById".equals(method.getName()) || "updateByIdWithNullValue".equals(method.getName())) {
                    property = "t." + (String)property;
                } else if (method.getName().startsWith("updateBy")) {
                    Table table = entityClass.getAnnotation(Table.class);
                    if (table != null) {
                        String name = table.name() == null || table.name().isEmpty() ? table.value() : table.name();
                        property = name + "." + (String)property;
                    } else {
                        property = Strings.underscoreName((String)entityClass.getSimpleName()) + "." + (String)property;
                    }
                }
                ColumnType columnType = field.getAnnotation(ColumnType.class);
                if (null == columnType) continue;
                ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, (String)property, field.getType());
                Class<TypeHandler<?>> clazz = typeHandler = columnType.typeHandler() == UnknownTypeHandler.class ? null : columnType.typeHandler();
                if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                    builder.jdbcType(columnType.jdbcType());
                }
                if (typeHandler != null) {
                    builder.typeHandler(this.getInstance(field.getType(), typeHandler));
                }
                parameterMappings.add(builder.build());
            }
            if (!CollectionUtils.isEmpty(parameterMappings)) {
                this.assistant.addParameterMap(mappedStatementId, entityClass, parameterMappings);
                return mappedStatementId;
            }
        }
        return null;
    }

    public Class<?> getEntityClass(Class<?> mapperClass) {
        Type[] types;
        for (Type t : types = mapperClass.getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)t;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private String parseResultMap(Method method, Class<?> mapper) {
        Class<?> returnType = this.getReturnType(method);
        ConstructorArgs args = method.getAnnotation(ConstructorArgs.class);
        Results results = method.getAnnotation(Results.class);
        TypeDiscriminator typeDiscriminator = method.getAnnotation(TypeDiscriminator.class);
        String resultMapId = this.generateResultMapName(method, mapper);
        this.applyResultMap(method, resultMapId, returnType, this.argsIf(args), this.resultsIf(results), typeDiscriminator, this.assistant);
        return resultMapId;
    }

    private Result[] resultsIf(Results results) {
        return results == null ? new Result[]{} : results.value();
    }

    private Arg[] argsIf(ConstructorArgs args) {
        return args == null ? new Arg[]{} : args.value();
    }

    private String generateResultMapName(Method method, Class<?> mapper) {
        Results results = method.getAnnotation(Results.class);
        if (results != null && !results.id().isEmpty()) {
            return this.type.getName() + "." + results.id();
        }
        StringBuilder suffix = new StringBuilder();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i, i + 1);
            Class parameterType = methodParameter.withContainingClass(mapper).getParameterType();
            suffix.append("-");
            suffix.append(parameterType.getSimpleName());
        }
        if (suffix.length() < 1) {
            suffix.append("-void");
        }
        return this.type.getName() + "." + method.getName() + suffix;
    }

    private void applyResultMap(Method method, String resultMapId, Class<?> returnType, Arg[] args, Result[] results, TypeDiscriminator discriminator, MapperBuilderAssistant assistant) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        this.applyConstructorArgs(args, returnType, resultMappings);
        this.applyResults(results, returnType, resultMappings);
        this.applyResultTypeHandler(method, returnType, resultMappings);
        Discriminator disc = this.applyDiscriminator(resultMapId, returnType, discriminator);
        assistant.addResultMap(resultMapId, returnType, null, disc, resultMappings, null);
        this.createDiscriminatorResultMaps(resultMapId, returnType, discriminator);
    }

    private void applyResultTypeHandler(Method method, Class<?> returnType, List<ResultMapping> resultMappings) {
        if (null != method && null != returnType) {
            ResultBeanAlias resultBeanAlias = method.getAnnotation(ResultBeanAlias.class);
            List<Field> fields = EntityUtils.getEntityNotStaticFields(returnType);
            for (Field field : fields) {
                String fieldName = field.getName();
                IgnoreField ignoreField = field.getAnnotation(IgnoreField.class);
                if (ignoreField != null) continue;
                ColumnType columnType = field.getAnnotation(ColumnType.class);
                Alias alias = (Alias)AnnotationUtils.getAnnotation((AnnotatedElement)field, Alias.class);
                if (null == columnType && null == alias) continue;
                ArrayList<Object> columnNameList = new ArrayList<Object>(2);
                if (alias != null && StringUtils.isNotBlank((CharSequence)alias.name())) {
                    columnNameList.add(fieldName);
                    columnNameList.add(alias.name());
                } else if (null != resultBeanAlias) {
                    columnNameList.add(fieldName);
                    columnNameList.add(resultBeanAlias.value() + "." + Strings.underscoreName((String)fieldName));
                } else {
                    columnNameList.add(fieldName);
                    columnNameList.add(Strings.underscoreName((String)fieldName));
                }
                Class<TypeHandler<?>> typeHandler = columnType == null || columnType.typeHandler() == UnknownTypeHandler.class ? null : columnType.typeHandler();
                for (String string : columnNameList) {
                    ResultMapping.Builder builder = new ResultMapping.Builder(this.configuration, fieldName, string, field.getType());
                    if (columnType != null && columnType.jdbcType() != JdbcType.UNDEFINED) {
                        builder.jdbcType(columnType.jdbcType());
                    }
                    if (typeHandler != null) {
                        builder.typeHandler(this.getInstance(field.getType(), typeHandler));
                    }
                    ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
                    if (columnType != null && columnType.isId()) {
                        flags.add(ResultFlag.ID);
                    }
                    builder.flags(flags);
                    resultMappings.add(builder.build());
                }
            }
        }
    }

    private <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<? extends TypeHandler<?>> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<TypeHandler<?>> c = typeHandlerClass.getConstructor(Class.class);
                return c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass);
            }
        }
        try {
            Constructor<TypeHandler<?>> c = typeHandlerClass.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass);
        }
    }

    private void createDiscriminatorResultMaps(String resultMapId, Class<?> resultType, TypeDiscriminator discriminator) {
        if (discriminator != null) {
            Case[] cases;
            for (Case c : cases = discriminator.cases()) {
                String caseResultMapId = resultMapId + "-" + c.value();
                ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
                this.applyConstructorArgs(c.constructArgs(), resultType, resultMappings);
                this.applyResults(c.results(), resultType, resultMappings);
                this.assistant.addResultMap(caseResultMapId, c.type(), resultMapId, null, resultMappings, null);
            }
        }
    }

    private Discriminator applyDiscriminator(String resultMapId, Class<?> resultType, TypeDiscriminator discriminator) {
        if (discriminator == null) {
            return null;
        }
        String column = discriminator.column();
        Class javaType = discriminator.javaType() == Void.TYPE ? String.class : discriminator.javaType();
        JdbcType jdbcType = discriminator.jdbcType() == JdbcType.UNDEFINED ? null : discriminator.jdbcType();
        Class typeHandler = discriminator.typeHandler() == UnknownTypeHandler.class ? null : discriminator.typeHandler();
        Case[] cases = discriminator.cases();
        HashMap<String, CallSite> discriminatorMap = new HashMap<String, CallSite>(10);
        for (Case c : cases) {
            String value = c.value();
            String caseResultMapId = resultMapId + "-" + value;
            discriminatorMap.put(value, (CallSite)((Object)caseResultMapId));
        }
        return this.assistant.buildDiscriminator(resultType, column, javaType, jdbcType, typeHandler, discriminatorMap);
    }

    private void applyConstructorArgs(Arg[] args, Class<?> resultType, List<ResultMapping> resultMappings) {
        for (Arg arg : args) {
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            flags.add(ResultFlag.CONSTRUCTOR);
            if (arg.id()) {
                flags.add(ResultFlag.ID);
            }
            Class typeHandler = arg.typeHandler() == UnknownTypeHandler.class ? null : arg.typeHandler();
            ResultMapping resultMapping = this.assistant.buildResultMapping(resultType, this.nullOrEmpty(arg.name()), this.nullOrEmpty(arg.column()), arg.javaType() == Void.TYPE ? null : arg.javaType(), arg.jdbcType() == JdbcType.UNDEFINED ? null : arg.jdbcType(), this.nullOrEmpty(arg.select()), this.nullOrEmpty(arg.resultMap()), (String)null, (String)null, typeHandler, flags, (String)null, (String)null, false);
            resultMappings.add(resultMapping);
        }
    }

    private void applyResults(Result[] results, Class<?> resultType, List<ResultMapping> resultMappings) {
        for (Result result : results) {
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (result.id()) {
                flags.add(ResultFlag.ID);
            }
            Class typeHandler = result.typeHandler() == UnknownTypeHandler.class ? null : result.typeHandler();
            ResultMapping resultMapping = this.assistant.buildResultMapping(resultType, this.nullOrEmpty(result.property()), this.nullOrEmpty(result.column()), result.javaType() == Void.TYPE ? null : result.javaType(), result.jdbcType() == JdbcType.UNDEFINED ? null : result.jdbcType(), this.hasNestedSelect(result) ? this.nestedSelectId(result) : null, (String)null, (String)null, (String)null, typeHandler, flags, (String)null, (String)null, this.isLazy(result));
            resultMappings.add(resultMapping);
        }
    }

    private boolean hasNestedSelect(Result result) {
        if (result.one().select().length() > 0 && result.many().select().length() > 0) {
            throw new BuilderException("Cannot use both @One and @Many annotations in the same @Result");
        }
        return result.one().select().length() > 0 || result.many().select().length() > 0;
    }

    private String nestedSelectId(Result result) {
        Object nestedSelect = result.one().select();
        String dot = ".";
        if (((String)nestedSelect).length() < 1) {
            nestedSelect = result.many().select();
        }
        if (!((String)nestedSelect).contains(dot)) {
            nestedSelect = this.type.getName() + "." + (String)nestedSelect;
        }
        return nestedSelect;
    }

    private boolean isLazy(Result result) {
        boolean isLazy = this.configuration.isLazyLoadingEnabled();
        if (result.one().select().length() > 0 && FetchType.DEFAULT != result.one().fetchType()) {
            isLazy = result.one().fetchType() == FetchType.LAZY;
        } else if (result.many().select().length() > 0 && FetchType.DEFAULT != result.many().fetchType()) {
            isLazy = result.many().fetchType() == FetchType.LAZY;
        }
        return isLazy;
    }

    private String nullOrEmpty(String value) {
        return value != null && value.trim().length() != 0 ? value : null;
    }

    private Class<?> getReturnType(Method method) {
        Class returnType = method.getReturnType();
        Type resolvedReturnType = TypeParameterResolver.resolveReturnType((Method)method, this.type);
        if (resolvedReturnType instanceof Class) {
            ResultType rt;
            returnType = (Class)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (Void.TYPE.equals(returnType) && (rt = method.getAnnotation(ResultType.class)) != null) {
                returnType = rt.value();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            return this.handlerParameterizedType(resolvedReturnType, method, returnType);
        }
        return returnType;
    }

    private Class<?> handlerParameterizedType(Type resolvedReturnType, Method method, Class<?> returnType) {
        ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
        Class rawType = (Class)parameterizedType.getRawType();
        int length = 2;
        if (!Collection.class.isAssignableFrom(rawType) && !Cursor.class.isAssignableFrom(rawType)) {
            Type[] actualTypeArguments;
            if (method.isAnnotationPresent(MapKey.class) && Map.class.isAssignableFrom(rawType) && (actualTypeArguments = parameterizedType.getActualTypeArguments()) != null && actualTypeArguments.length == length) {
                Type returnTypeParameter = actualTypeArguments[1];
                if (returnTypeParameter instanceof Class) {
                    returnType = (Class)returnTypeParameter;
                } else if (returnTypeParameter instanceof ParameterizedType) {
                    returnType = (Class)((ParameterizedType)returnTypeParameter).getRawType();
                }
            }
        } else {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                Type returnTypeParameter = actualTypeArguments[0];
                if (returnTypeParameter instanceof Class) {
                    returnType = (Class)returnTypeParameter;
                } else if (returnTypeParameter instanceof ParameterizedType) {
                    returnType = (Class)((ParameterizedType)returnTypeParameter).getRawType();
                } else if (returnTypeParameter instanceof GenericArrayType) {
                    Class componentType = (Class)((GenericArrayType)returnTypeParameter).getGenericComponentType();
                    returnType = Array.newInstance(componentType, 0).getClass();
                }
            }
        }
        return returnType;
    }

    private SqlSource getSqlSourceFromAnnotations(Method method, Class<?> mapper, SqlCommand sqlCommand, Configuration configuration, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        if (sqlCommand.isNeedInterceptGenerate()) {
            return new InterceptSqlSource(method, mapper, sqlCommand.getSql());
        }
        return languageDriver.createSqlSource(configuration, sqlCommand.getSql(), parameterTypeClass);
    }
}

