/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.GenericMapper;
import com.cyberway.mp.bc.dal.LogicDeleteSelectVisitor;
import com.cyberway.mp.bc.dal.annotation.IgnoreLogicDeleteFilter;
import com.cyberway.mp.bc.dal.annotation.IgnoreTenantFilter;
import com.cyberway.mp.bc.dal.annotation.MustTenantFilter;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.generate.ProxyBoundSql;
import com.cyberway.mp.bc.dal.generate.ProxySqlSource;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithTenant;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class TenantAndLogicDeleteFilterInterceptor
implements Interceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DALProperties dalProperties;
    private final String tenantValueMark;
    private final Cache<String, String> sqlCache = Caffeine.newBuilder().maximumSize(10000L).build();

    public TenantAndLogicDeleteFilterInterceptor(DALProperties dalProperties) {
        this.dalProperties = dalProperties;
        String uuid = UUID.randomUUID().toString();
        this.tenantValueMark = uuid + "-tenant-id-" + uuid;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Optional<Method> mapperMethodOptional;
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        String msId = ms.getId();
        int lastDotIndex = msId.lastIndexOf(46);
        if (lastDotIndex < 0) {
            this.logger.warn("Unknown mapper method id format [{}]", (Object)msId);
            return invocation.proceed();
        }
        String mapperClassName = msId.substring(0, lastDotIndex);
        String mapperMethodName = msId.substring(lastDotIndex + 1);
        Class<?> mapperClass = Class.forName(mapperClassName);
        Class entityClass = null;
        if (GenericMapper.class.isAssignableFrom(mapperClass)) {
            ResolvableType resolvableType = ResolvableType.forClass(mapperClass).as(GenericMapper.class);
            ResolvableType entityType = resolvableType.getGeneric(new int[]{0});
            if (entityType.equals((Object)ResolvableType.NONE)) {
                this.logger.warn("Can't get entity type for mapper [{}]", (Object)mapperClassName);
                return invocation.proceed();
            }
            entityClass = entityType.resolve();
        }
        if ((mapperMethodOptional = Arrays.stream(mapperClass.getMethods()).filter(m -> mapperMethodName.equals(m.getName())).findAny()).isEmpty()) {
            this.logger.warn("Can't find mapper method for id [{}]", (Object)msId);
            return invocation.proceed();
        }
        Method mapperMethod = mapperMethodOptional.get();
        Class finalEntityClass = entityClass;
        boolean needTenantFilter = this.checkNeedTenantFilter(mapperMethod, mapperClass, entityClass);
        boolean needLogicDelete = this.checkNeedLogicDeleteFilter(mapperMethod, mapperClass, entityClass);
        BoundSql boundSql = ms.getSqlSource().getBoundSql(invocation.getArgs()[1]);
        String sql = boundSql.getSql();
        String newSql = (String)this.sqlCache.get((Object)String.format("%s:%s", msId, sql), k -> this.genNewSql(needTenantFilter, needLogicDelete, sql, finalEntityClass));
        if (StringUtils.isNotBlank((CharSequence)newSql)) {
            Long tenantId = ServiceContext.getContext().getRequestTenantId();
            ProxyBoundSql newBoundSql = new ProxyBoundSql(ms.getConfiguration(), newSql.replace("'" + this.tenantValueMark + "'", tenantId == null ? "null" : tenantId.toString()), boundSql);
            ProxySqlSource newSqlSource = new ProxySqlSource(newBoundSql, ms.getSqlSource());
            invocation.getArgs()[0] = this.buildNewMappedStatement(ms, newSqlSource);
        }
        return invocation.proceed();
    }

    private boolean checkNeedLogicDeleteFilter(Method mapperMethod, Class<?> mapperClass, Class<?> entityClass) {
        if (AnnotationUtils.findAnnotation(mapperClass, IgnoreLogicDeleteFilter.class) != null) {
            return false;
        }
        if (AnnotationUtils.findAnnotation((Method)mapperMethod, IgnoreLogicDeleteFilter.class) != null) {
            return false;
        }
        return null != entityClass;
    }

    private boolean checkNeedTenantFilter(Method mapperMethod, Class<?> mapperClass, Class<?> entityClass) {
        if (!this.dalProperties.isNeedTenantFilter()) {
            return false;
        }
        if (AnnotationUtils.findAnnotation(mapperClass, IgnoreTenantFilter.class) != null) {
            return false;
        }
        if (AnnotationUtils.findAnnotation((Method)mapperMethod, IgnoreTenantFilter.class) != null) {
            return false;
        }
        if (null != entityClass && BusinessEntityWithTenant.class.isAssignableFrom(entityClass)) {
            return true;
        }
        return AnnotationUtils.findAnnotation(mapperClass, MustTenantFilter.class) != null || AnnotationUtils.findAnnotation((Method)mapperMethod, MustTenantFilter.class) != null;
    }

    private MappedStatement buildNewMappedStatement(MappedStatement oldMappedStatement, SqlSource sqlSource) {
        return new MappedStatement.Builder(oldMappedStatement.getConfiguration(), oldMappedStatement.getId(), sqlSource, oldMappedStatement.getSqlCommandType()).parameterMap(oldMappedStatement.getParameterMap()).resource(oldMappedStatement.getResource()).fetchSize(oldMappedStatement.getFetchSize()).timeout(oldMappedStatement.getTimeout()).statementType(oldMappedStatement.getStatementType()).keyGenerator(oldMappedStatement.getKeyGenerator()).keyProperty(String.join((CharSequence)",", (CharSequence[])ObjectUtils.defaultIfNull((Object)oldMappedStatement.getKeyProperties(), (Object)new String[0]))).keyColumn(String.join((CharSequence)",", (CharSequence[])ObjectUtils.defaultIfNull((Object)oldMappedStatement.getKeyColumns(), (Object)new String[0]))).databaseId(oldMappedStatement.getDatabaseId()).lang(oldMappedStatement.getLang()).resultOrdered(oldMappedStatement.isResultOrdered()).resultSets(String.join((CharSequence)",", (CharSequence[])ObjectUtils.defaultIfNull((Object)oldMappedStatement.getResultSets(), (Object)new String[0]))).resultMaps(oldMappedStatement.getResultMaps()).resultSetType(oldMappedStatement.getResultSetType()).flushCacheRequired(oldMappedStatement.isFlushCacheRequired()).useCache(oldMappedStatement.isUseCache()).cache(oldMappedStatement.getCache()).build();
    }

    private String logAndReturnString(Statement statement, String sourceSql) {
        this.logger.debug("source sql: {}", (Object)sourceSql);
        this.logger.debug("new sql: {}", (Object)statement);
        return statement.toString();
    }

    private void logCantModifySql(String sql) {
        this.logger.warn("Can't modify sql [{}]", (Object)sql);
    }

    private String genNewSql(boolean needTenantFilter, boolean needLogicDelete, String sql, Class<?> entityClass) {
        Statement statement;
        if (sql.length() > 7 && sql.substring(0, 7).equalsIgnoreCase("insert ")) {
            return "";
        }
        String tableName = TenantAndLogicDeleteFilterInterceptor.calTableName(entityClass);
        try {
            statement = CCJSqlParserUtil.parse((String)sql, parser -> parser.withSquareBracketQuotation(true));
        }
        catch (JSQLParserException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
        if (statement instanceof Select) {
            Select select = (Select)statement;
            return this.genNewSelectSql(needTenantFilter, needLogicDelete, select, tableName, sql);
        }
        if (needTenantFilter) {
            if (statement instanceof Update) {
                Update update = (Update)statement;
                return this.genNewUpdateSql(update, tableName, sql);
            }
            if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                return this.genNewDeleteSql(delete, tableName, sql);
            }
        }
        if (!needTenantFilter || statement instanceof Insert) {
            return "";
        }
        this.logCantModifySql(sql);
        return "";
    }

    private static String calTableName(Class<?> entityClass) {
        Table table;
        String tableName = entityClass == null ? null : ((table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class)) == null ? Strings.underscoreName((String)entityClass.getSimpleName()) : table.name());
        return tableName;
    }

    private String genNewSelectSql(boolean needTenantFilter, boolean needLogicDelete, Select select, String tableName, String sourceSql) {
        PlainSelect plainSelect = select.getPlainSelect();
        TenantSelectVisitor selectVisitor = new TenantSelectVisitor(tableName, this.tenantValueMark);
        if (needTenantFilter) {
            plainSelect.accept((SelectVisitor)selectVisitor);
        }
        LogicDeleteSelectVisitor logicDeleteSelectVisitor = new LogicDeleteSelectVisitor();
        if (needLogicDelete) {
            plainSelect.accept((SelectVisitor)logicDeleteSelectVisitor);
        }
        if (selectVisitor.isModified() || logicDeleteSelectVisitor.isModified()) {
            return this.logAndReturnString((Statement)select, sourceSql);
        }
        this.logCantModifySql(sourceSql);
        return "";
    }

    private String genNewUpdateSql(Update update, String tableName, String sourceSql) {
        net.sf.jsqlparser.schema.Table table = update.getTable();
        if (tableName == null || table.getName().equalsIgnoreCase(tableName)) {
            update.setWhere(TenantAndLogicDeleteFilterInterceptor.buildNewWhere(table, update.getWhere(), this.tenantValueMark));
            return this.logAndReturnString((Statement)update, sourceSql);
        }
        FromItem fromItem = update.getFromItem();
        if (fromItem != null) {
            TenantFromVisitor fromVisitor = new TenantFromVisitor(tableName, this.tenantValueMark);
            fromItem.accept((FromItemVisitor)fromVisitor);
            if (fromVisitor.isModified()) {
                return this.logAndReturnString((Statement)update, sourceSql);
            }
            if (fromVisitor.getMainTable() != null) {
                update.setWhere(TenantAndLogicDeleteFilterInterceptor.buildNewWhere(fromVisitor, update.getWhere(), this.tenantValueMark));
                return this.logAndReturnString((Statement)update, sourceSql);
            }
        }
        if (update.getWhere() != null) {
            TenantWhereVisitor whereVisitor = new TenantWhereVisitor(tableName, this.tenantValueMark);
            update.getWhere().accept((ExpressionVisitor)whereVisitor);
            if (whereVisitor.isModified()) {
                return this.logAndReturnString((Statement)update, sourceSql);
            }
        }
        if (this.acceptUpdateJoins(update, tableName)) {
            return this.logAndReturnString((Statement)update, sourceSql);
        }
        this.logCantModifySql(sourceSql);
        return "";
    }

    private boolean acceptUpdateJoins(Update update, String tableName) {
        return this.acceptJoins(update.getJoins(), () -> ((Update)update).getWhere(), arg_0 -> ((Update)update).setWhere(arg_0), tableName);
    }

    private String genNewDeleteSql(Delete delete, String tableName, String sourceSql) {
        net.sf.jsqlparser.schema.Table table = delete.getTable();
        if (tableName == null || table.getName().equalsIgnoreCase(tableName)) {
            delete.setWhere(TenantAndLogicDeleteFilterInterceptor.buildNewWhere(table, delete.getWhere(), this.tenantValueMark));
            return this.logAndReturnString((Statement)delete, sourceSql);
        }
        if (delete.getWhere() != null) {
            TenantWhereVisitor whereVisitor = new TenantWhereVisitor(tableName, this.tenantValueMark);
            delete.getWhere().accept((ExpressionVisitor)whereVisitor);
            if (whereVisitor.isModified()) {
                return this.logAndReturnString((Statement)delete, sourceSql);
            }
        }
        if (this.acceptDeleteJoins(delete, tableName)) {
            return this.logAndReturnString((Statement)delete, sourceSql);
        }
        this.logCantModifySql(sourceSql);
        return "";
    }

    private boolean acceptDeleteJoins(Delete delete, String tableName) {
        return this.acceptJoins(delete.getJoins(), () -> ((Delete)delete).getWhere(), arg_0 -> ((Delete)delete).setWhere(arg_0), tableName);
    }

    private boolean acceptJoins(List<Join> joins, Supplier<Expression> whereGetter, Consumer<Expression> whereSetter, String tableName) {
        boolean joinModified = false;
        if (joins != null) {
            for (Join join : joins) {
                TenantFromVisitor joinFromVisitor = new TenantFromVisitor(tableName, this.tenantValueMark);
                join.getRightItem().accept((FromItemVisitor)joinFromVisitor);
                if (joinFromVisitor.isModified()) {
                    joinModified = true;
                    continue;
                }
                if (joinFromVisitor.getMainTable() == null) continue;
                whereSetter.accept(TenantAndLogicDeleteFilterInterceptor.buildNewWhere(joinFromVisitor, whereGetter.get(), this.tenantValueMark));
                joinModified = true;
            }
        }
        return joinModified;
    }

    private static Expression buildNewWhere(TenantFromVisitor fromVisitor, Expression where, String tenantValueMark) {
        return TenantAndLogicDeleteFilterInterceptor.buildNewWhere(fromVisitor.getMainTable(), where, tenantValueMark);
    }

    private static Expression buildNewWhere(net.sf.jsqlparser.schema.Table table, Expression where, String tenantValueMark) {
        Column tenantColumn = new Column().withColumnName("tenant_id");
        if (table.getAlias() != null) {
            tenantColumn.withTable(table);
        }
        if (where == null) {
            return new EqualsTo().withLeftExpression((Expression)tenantColumn).withRightExpression((Expression)new StringValue(tenantValueMark));
        }
        if (where instanceof Parenthesis || where instanceof AndExpression || where instanceof ComparisonOperator || where instanceof InExpression) {
            return new AndExpression().withLeftExpression(where).withRightExpression((Expression)new EqualsTo().withLeftExpression((Expression)tenantColumn).withRightExpression((Expression)new StringValue(tenantValueMark)));
        }
        return new AndExpression().withLeftExpression((Expression)new Parenthesis().withExpression(where)).withRightExpression((Expression)new EqualsTo().withLeftExpression((Expression)tenantColumn).withRightExpression((Expression)new StringValue(tenantValueMark)));
    }

    private static class TenantSelectVisitor
    extends SelectVisitorAdapter {
        private final String tableName;
        private final String tenantValueMark;
        private boolean modified = false;

        TenantSelectVisitor(String tableName, String tenantValueMark) {
            this.tableName = tableName;
            this.tenantValueMark = tenantValueMark;
        }

        public void visit(PlainSelect plainSelect) {
            FromItem fromItem = plainSelect.getFromItem();
            this.acceptFromItem(plainSelect, fromItem);
            if (this.modified) {
                return;
            }
            List joins = plainSelect.getJoins();
            if (joins != null) {
                for (Join join : joins) {
                    FromItem joinFromItem = join.getRightItem();
                    this.acceptFromItem(plainSelect, joinFromItem);
                }
            }
            if (this.modified) {
                return;
            }
            Expression where = plainSelect.getWhere();
            TenantWhereVisitor whereVisitor = new TenantWhereVisitor(this.tableName, this.tenantValueMark);
            where.accept((ExpressionVisitor)whereVisitor);
            if (whereVisitor.isModified()) {
                this.modified = true;
            }
        }

        private void acceptFromItem(PlainSelect plainSelect, FromItem fromItem) {
            TenantFromVisitor fromVisitor = new TenantFromVisitor(this.tableName, this.tenantValueMark);
            fromItem.accept((FromItemVisitor)fromVisitor);
            if (fromVisitor.isModified()) {
                this.modified = true;
            } else if (fromVisitor.getMainTable() != null) {
                Expression where = plainSelect.getWhere();
                plainSelect.setWhere(TenantAndLogicDeleteFilterInterceptor.buildNewWhere(fromVisitor, where, this.tenantValueMark));
                this.modified = true;
            }
        }

        public boolean isModified() {
            return this.modified;
        }
    }

    private static class TenantFromVisitor
    extends FromItemVisitorAdapter {
        private final String tableName;
        private final String tenantValueMark;
        private boolean modified = false;
        private net.sf.jsqlparser.schema.Table mainTable;

        TenantFromVisitor(String tableName, String tenantValueMark) {
            this.tableName = tableName;
            this.tenantValueMark = tenantValueMark;
        }

        public void visit(net.sf.jsqlparser.schema.Table table) {
            if (this.tableName == null || this.tableName.equalsIgnoreCase(table.getName())) {
                this.mainTable = table;
            }
        }

        public void visit(ParenthesedSelect parenthesedSelect) {
            PlainSelect plainSelect = parenthesedSelect.getPlainSelect();
            TenantSelectVisitor selectVisitor = new TenantSelectVisitor(this.tableName, this.tenantValueMark);
            plainSelect.accept((SelectVisitor)selectVisitor);
            if (selectVisitor.isModified()) {
                this.modified = true;
            }
        }

        public boolean isModified() {
            return this.modified;
        }

        public net.sf.jsqlparser.schema.Table getMainTable() {
            return this.mainTable;
        }
    }

    private static class TenantWhereVisitor
    extends ExpressionVisitorAdapter {
        private final String tableName;
        private final String tenantValueMark;
        private boolean modified = false;

        TenantWhereVisitor(String tableName, String tenantValueMark) {
            this.tableName = tableName;
            this.tenantValueMark = tenantValueMark;
        }

        public void visit(ParenthesedSelect parenthesedSelect) {
            PlainSelect plainSelect = parenthesedSelect.getPlainSelect();
            TenantSelectVisitor selectVisitor = new TenantSelectVisitor(this.tableName, this.tenantValueMark);
            plainSelect.accept((SelectVisitor)selectVisitor);
            if (selectVisitor.isModified()) {
                this.modified = true;
            }
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

