/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.config;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.MultiDataSourceHolder;
import com.cyberway.mp.bc.dal.config.Dialect;
import com.cyberway.mp.bc.dal.config.multi.DataSourceProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ConfigurationProperties(value="spring.dal")
public class DALProperties
implements ApplicationContextAware {
    public static final int COL_CASE_TYPE_NOT_HANDLE = 0;
    public static final int COL_CASE_TYPE_UPPER_CASE = 1;
    public static final int COL_CASE_TYPE_LOWER_CASE = 2;
    public static final String PREFIX = "spring.dal";
    public static final String DIALECT_NO_PREFIX = "dialect";
    public static final String DIALECT = "spring.dal.dialect";
    public static final String USE_MULTI_SOURCE_NO_PREFIX = "use-multi-datasource";
    public static final String USE_MULTI_SOURCE = "spring.dal.use-multi-datasource";
    private String dialect = Dialect.MYSQL.name().toLowerCase();
    private boolean useGeneratedKeys = false;
    private boolean useRedisWorkerId = false;
    private boolean useMultiDatasource = false;
    private Map<String, DataSourceProperty> multiDatasource = new HashMap<String, DataSourceProperty>();
    private long workerId = 0L;
    private long datacenterId = 0L;
    private boolean needTenantFilter = true;
    private int batchSize = 500;
    private int colCaseType = 0;
    private ApplicationContext applicationContext;
    private Map<String, Set<String>> ignoreUpdateFields = new HashMap<String, Set<String>>();

    public Map<String, Set<String>> getIgnoreUpdateFields() {
        return this.ignoreUpdateFields;
    }

    public void setIgnoreUpdateFields(Map<String, Set<String>> ignoreUpdateFields) {
        this.ignoreUpdateFields = ignoreUpdateFields;
    }

    public int getColCaseType() {
        return this.colCaseType;
    }

    public void setColCaseType(int colCaseType) {
        this.colCaseType = colCaseType;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public boolean isUseGeneratedKeys() {
        return this.useGeneratedKeys;
    }

    public void setUseGeneratedKeys(boolean useGeneratedKeys) {
        this.useGeneratedKeys = useGeneratedKeys;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(long workerId) {
        this.workerId = workerId;
    }

    public long getDatacenterId() {
        return this.datacenterId;
    }

    public void setDatacenterId(long datacenterId) {
        this.datacenterId = datacenterId;
    }

    public boolean isUseRedisWorkerId() {
        return this.useRedisWorkerId;
    }

    public void setUseRedisWorkerId(boolean useRedisWorkerId) {
        this.useRedisWorkerId = useRedisWorkerId;
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    public void setUseRedisWordId(boolean useRedisWordId) {
        this.useRedisWorkerId = useRedisWordId;
    }

    public boolean isUseMultiDatasource() {
        return this.useMultiDatasource;
    }

    public void setUseMultiDatasource(boolean useMultiDatasource) {
        this.useMultiDatasource = useMultiDatasource;
    }

    public Map<String, DataSourceProperty> getMultiDatasource() {
        return this.multiDatasource;
    }

    public void setMultiDatasource(Map<String, DataSourceProperty> multiDatasource) {
        this.multiDatasource = multiDatasource;
    }

    public boolean currentDialectIsSqlServer() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.SQLSERVER);
    }

    public String currentDialect() {
        if (this.useMultiDatasource) {
            DataSourceProperty dataSourceProperty;
            MultiDataSourceHolder holder = (MultiDataSourceHolder)this.applicationContext.getBean(MultiDataSourceHolder.class);
            String currentDataSource = holder.currentDataSource();
            DataSourceProperty dataSourceProperty2 = dataSourceProperty = this.multiDatasource.get(currentDataSource) != null ? this.multiDatasource.get(currentDataSource) : this.multiDatasource.get("default");
            if (dataSourceProperty == null) {
                throw new BaseException("00000001", "\u6570\u636e\u6e90" + currentDataSource + "\u627e\u4e0d\u5230\u76f8\u5173\u914d\u7f6e");
            }
            return dataSourceProperty.getDialect();
        }
        return this.dialect;
    }

    public boolean currentDialectIsOracle() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.ORACLE);
    }

    public boolean currentDialectIsPostgresql() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.POSTGRESQL);
    }

    public boolean currentDialectIsMysql() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.MYSQL);
    }

    public boolean currentDialectIsH2() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.H2);
    }

    public boolean currentDialectIsOracleOrSqlServer() {
        return this.currentDialectIsOracle() || this.currentDialectIsSqlServer();
    }

    public boolean currentDialectIsMysqlOrH2() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.H2) || Dialect.from(this.currentDialect()).equals((Object)Dialect.MYSQL);
    }

    public boolean currentDialectIsDM() {
        return Dialect.from(this.currentDialect()).equals((Object)Dialect.DM);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean isNeedTenantFilter() {
        return this.needTenantFilter;
    }

    public void setNeedTenantFilter(boolean needTenantFilter) {
        this.needTenantFilter = needTenantFilter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

