/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.config;

import com.cyberway.mp.bc.dal.config.Dialect;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DialectBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    @Autowired
    private ApplicationContext applicationContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        if (this.isUseMultiDatasource()) {
            return;
        }
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        String configDialectStr = this.getDialect();
        Dialect configDialect = Dialect.from(configDialectStr);
        for (String beanName : beanNames = defaultListableBeanFactory.getBeanNamesForAnnotation(com.cyberway.mp.bc.dal.annotation.Dialect.class)) {
            Object bean = defaultListableBeanFactory.getBean(beanName);
            com.cyberway.mp.bc.dal.annotation.Dialect dialectAnno = bean.getClass().getAnnotation(com.cyberway.mp.bc.dal.annotation.Dialect.class);
            if (configDialect.match(dialectAnno.name())) continue;
            defaultListableBeanFactory.removeBeanDefinition(beanName);
        }
    }

    private boolean isUseMultiDatasource() {
        Boolean useMultiSource = (Boolean)this.applicationContext.getEnvironment().getProperty("spring.dal.use-multi-datasource", Boolean.class);
        if (useMultiSource == null) {
            useMultiSource = (Boolean)this.applicationContext.getEnvironment().getProperty("use-multi-datasource", Boolean.class);
        }
        if (useMultiSource == null) {
            useMultiSource = false;
        }
        return useMultiSource;
    }

    private String getDialect() {
        String configDialectStr = this.applicationContext.getEnvironment().getProperty("spring.dal.dialect");
        if (configDialectStr == null) {
            configDialectStr = this.applicationContext.getEnvironment().getProperty("dialect");
        }
        return configDialectStr;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

