/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.config;

import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.GenericMapper;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Table;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;

public class LogicDeletedMetaHolder
implements BeanPostProcessor {
    private static final Map<String, LogicDelete> LOGIC_DELETE_MAP = new ConcurrentHashMap<String, LogicDelete>();
    private final Logger logger = LoggerFactory.getLogger(LogicDeletedMetaHolder.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> targetClass = this.getTargetClassIfProxy(bean);
        if (MapperFactoryBean.class.isAssignableFrom(targetClass)) {
            MapperFactoryBean mapperFactoryBean = (MapperFactoryBean)bean;
            Class mapperInterface = mapperFactoryBean.getMapperInterface();
            ResolvableType resolvableType = ResolvableType.forClass((Class)mapperInterface).as(GenericMapper.class);
            ResolvableType entityType = resolvableType.getGeneric(new int[]{0});
            if (entityType.equals((Object)ResolvableType.NONE)) {
                this.logger.debug("Can't get entity type for mapper [{}]", (Object)mapperInterface);
            } else {
                Table table;
                Class entityClass = entityType.resolve();
                LogicDelete logicDelete = entityClass == null ? null : (LogicDelete)AnnotationUtils.findAnnotation((Class)entityClass, LogicDelete.class);
                Table table2 = table = entityClass == null ? null : (Table)AnnotationUtils.findAnnotation((Class)entityClass, Table.class);
                if (null != logicDelete) {
                    LogicDeletedMetaHolder.putLogicDeleteMeta(table == null ? Strings.underscoreName((String)entityClass.getSimpleName()) : table.name(), logicDelete);
                }
            }
        }
        return bean;
    }

    public static LogicDelete getLogicDeleteMeta(String tableName) {
        return StringUtils.isBlank((CharSequence)tableName) ? null : LOGIC_DELETE_MAP.get(StringUtils.lowerCase((String)tableName));
    }

    private static void putLogicDeleteMeta(String tableName, LogicDelete logicDelete) {
        if (StringUtils.isNotBlank((CharSequence)tableName) && null != logicDelete) {
            LOGIC_DELETE_MAP.put(StringUtils.lowerCase((String)tableName), logicDelete);
        }
    }

    private Class<?> getTargetClassIfProxy(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy.getClass();
        }
        return AopProxyUtils.ultimateTargetClass((Object)proxy);
    }
}

