/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.config;

import com.cyberway.mp.bc.dal.GenericMapper;
import com.cyberway.mp.bc.dal.MappedStatementBuilder;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.DalSupportAnnotation;
import com.cyberway.mp.bc.dal.annotation.IgnoreRepository;
import com.cyberway.mp.bc.dal.generate.SqlGeneratorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class MappedStatementRegister
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MappedStatementRegister.class);
    @Autowired
    private SqlSession sqlSession;
    @Autowired
    private SqlGeneratorFactory sqlGeneratorFactory;
    private final ConcurrentMap<Object, Object> hasEnhanceMapper = new ConcurrentHashMap<Object, Object>();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Configuration configuration = this.sqlSession.getConfiguration();
        ArrayList mappers = new ArrayList(configuration.getMapperRegistry().getMappers());
        for (Class mapper : mappers) {
            if (!this.isNeedEnhanceMapper(mapper)) continue;
            for (Method method : mapper.getMethods()) {
                this.buildStatementIfNeed(method, configuration, mapper);
            }
        }
        logger.info(" MappedStatementRegister init ");
    }

    private boolean isNeedEnhanceMapper(Class<?> mapper) {
        return this.hasEnhanceMapper.putIfAbsent(mapper, mapper) == null && ClassUtils.isAssignable(mapper, GenericMapper.class) && !mapper.equals(GenericMapper.class) && mapper.getAnnotation(IgnoreRepository.class) == null;
    }

    private void buildStatementIfNeed(Method method, Configuration configuration, Class<?> mapper) {
        if (this.noMybatisAnnotations(method) && this.isNeedBuild(method)) {
            this.build(method, mapper, configuration);
        }
    }

    private boolean noMybatisAnnotations(Method method) {
        Annotation[] annotations = method.getDeclaredAnnotations();
        return Arrays.stream(annotations).allMatch(a -> AnnotationUtils.isAnnotationDeclaredLocally(DalSupportAnnotation.class, a.annotationType()));
    }

    private boolean isNeedBuild(Method method) {
        return this.sqlGeneratorFactory.find(method) != null;
    }

    private void build(Method method, Class<?> mapper, Configuration configuration) {
        SqlCommand sqlCommand = this.sqlGeneratorFactory.find(method).generate(method, mapper);
        if (sqlCommand != null) {
            String mappedStatementId = mapper.getName() + "." + method.getName();
            this.buildMappedStatement(mapper, method, configuration, sqlCommand, mappedStatementId, mapper.getName());
        }
    }

    private void buildMappedStatement(Class<?> mapper, Method method, Configuration configuration, SqlCommand sqlCommand, String mappedStatementId, String nameSpace) {
        MapperBuilderAssistant assistant = new MapperBuilderAssistant(configuration, method.getName().replace('.', '/') + ".java (best guess)");
        assistant.setCurrentNamespace(nameSpace);
        MappedStatementBuilder builder = new MappedStatementBuilder(configuration, mapper, assistant);
        builder.buildStatement(mapper, method, configuration, mappedStatementId, sqlCommand);
    }
}

