/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.config;

import com.cyberway.mp.bc.dal.DbBatchOperatorAspect;
import com.cyberway.mp.bc.dal.GenericMapperInterceptor;
import com.cyberway.mp.bc.dal.TenantAndLogicDeleteFilterInterceptor;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.config.LogicDeletedMetaHolder;
import com.cyberway.mp.bc.dal.config.multi.MultiDatSourceConfig;
import com.cyberway.mp.bc.dal.generate.SqlGeneratorFactory;
import com.cyberway.mp.bc.dal.handler.ChangeBooleanValueTypeHandler;
import com.cyberway.mp.bc.dal.handler.MssqlGeometryTypeHandler;
import com.cyberway.mp.bc.dal.handler.MysqlGeometryTypeHandler;
import com.cyberway.mp.bc.dal.handler.PgsqlGeometryTypeHandler;
import com.cyberway.mp.bc.dal.util.IdWorker;
import com.cyberway.mp.bc.dal.util.RedisWorkId;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.type.TypeHandler;
import org.locationtech.jts.geom.Geometry;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;

@ComponentScan(basePackages={"com.cyberway.mp.bc.dal"})
@Configuration
@EnableConfigurationProperties(value={DALProperties.class})
@Import(value={MultiDatSourceConfig.class})
public class MybatisConfig {
    public static final int ORDER_MP_DAL_MYBATIS_CONFIG_CUSTOMIZER = 1000;
    public static final int ORDER_MP_DAL_MYBATIS_TENANT_INTERCEPTOR = 1000;
    public static final int ORDER_MP_DAL_MYBATIS_GENERIC_INTERCEPTOR = 2000;

    @Bean
    @Order(value=1000)
    public ConfigurationCustomizer mybatisConfigurationCustomizer(DALProperties dalProperties) {
        return configuration -> {
            configuration.setMapUnderscoreToCamelCase(true);
            configuration.setUseGeneratedKeys(dalProperties.isUseGeneratedKeys());
            if (dalProperties.currentDialectIsPostgresql()) {
                configuration.getTypeHandlerRegistry().register(Boolean.class, (TypeHandler)new ChangeBooleanValueTypeHandler());
                configuration.getTypeHandlerRegistry().register(Boolean.TYPE, (TypeHandler)new ChangeBooleanValueTypeHandler());
                configuration.getTypeHandlerRegistry().register(Geometry.class, (TypeHandler)new PgsqlGeometryTypeHandler());
            } else if (dalProperties.currentDialectIsMysql()) {
                configuration.getTypeHandlerRegistry().register(Geometry.class, (TypeHandler)new MysqlGeometryTypeHandler());
            } else if (dalProperties.currentDialectIsSqlServer()) {
                configuration.getTypeHandlerRegistry().register(Geometry.class, (TypeHandler)new MssqlGeometryTypeHandler());
            }
        };
    }

    @Bean
    @Order(value=1000)
    public TenantAndLogicDeleteFilterInterceptor tenantFilterInterceptor(DALProperties dalProperties) {
        return new TenantAndLogicDeleteFilterInterceptor(dalProperties);
    }

    @Bean
    public IdWorker idWorker(DALProperties dalProperties, @Autowired(required=false) RedisTemplate<Object, Object> redisTemplate) {
        if (dalProperties.isUseRedisWorkerId()) {
            RedisWorkId redisWorkId = new RedisWorkId(dalProperties.getDatacenterId(), redisTemplate);
            return new IdWorker(dalProperties.getDatacenterId(), 0L, redisWorkId);
        }
        return new IdWorker(dalProperties.getWorkerId(), dalProperties.getDatacenterId(), 0L);
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        return new VendorDatabaseIdProvider();
    }

    @Bean
    @Order(value=2000)
    public GenericMapperInterceptor genericDaoInterceptor(SqlGeneratorFactory sqlGeneratorFactory, IdWorker idWorker) {
        return new GenericMapperInterceptor(sqlGeneratorFactory, idWorker);
    }

    @Bean
    public DbBatchOperatorAspect dbBatchOperatorAspect(DALProperties dalProperties) {
        return new DbBatchOperatorAspect(dalProperties);
    }

    @Bean
    public LogicDeletedMetaHolder logicDeletedMetaHolder() {
        return new LogicDeletedMetaHolder();
    }
}

