/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.config.multi;

import com.cyberway.mp.bc.dal.MultiDataSourceHolder;
import com.cyberway.mp.bc.dal.annotation.MultiDataSource;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.config.DialectBeanFactoryPostProcessor;
import com.cyberway.mp.bc.dal.datasource.multi.DataSourceCreator;
import com.cyberway.mp.bc.dal.datasource.multi.DataSourceCreatorFactory;
import com.cyberway.mp.bc.dal.datasource.multi.MultiDataSourceContextHolder;
import com.cyberway.mp.bc.dal.datasource.multi.RoutingDataSource;
import com.cyberway.mp.bc.dal.datasource.multi.aop.MultiDataSourceAnnotationInterceptor;
import com.cyberway.mp.bc.dal.datasource.multi.creator.DruidDataSourceCreator;
import com.cyberway.mp.bc.dal.datasource.multi.creator.HikariDataSourceCreator;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DALProperties.class})
@ConditionalOnProperty(prefix="spring.dal", name={"use-multi-datasource"}, havingValue="true")
public class MultiDatSourceConfig {
    @Bean
    public DataSourceCreator hikariDataSourceCreator() {
        return new HikariDataSourceCreator();
    }

    @Bean
    public DataSourceCreator druidDataSourceCreator(DALProperties dalProperties) {
        return new DruidDataSourceCreator(dalProperties);
    }

    @Bean
    public DataSourceCreatorFactory dataSourceCreatorFactory(DALProperties dalProperties) {
        return new DataSourceCreatorFactory(dalProperties);
    }

    @Bean
    public Advisor datasourceAnnotationAdvisor() {
        MultiDataSourceAnnotationInterceptor interceptor = new MultiDataSourceAnnotationInterceptor();
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AnnotationMatchingPointcut classPointcut = new AnnotationMatchingPointcut(MultiDataSource.class, true);
        AnnotationMatchingPointcut pointcut = AnnotationMatchingPointcut.forMethodAnnotation(MultiDataSource.class);
        ComposablePointcut composablePointcut = new ComposablePointcut((Pointcut)classPointcut);
        composablePointcut.union((Pointcut)pointcut);
        advisor.setPointcut((Pointcut)composablePointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }

    @Bean
    public DataSource dataSource(DALProperties dALProperties, DataSourceCreatorFactory dataSourceCreatorFactory) {
        return new RoutingDataSource(dALProperties, dataSourceCreatorFactory);
    }

    @Bean
    public MultiDataSourceHolder multiDataSourceHolder() {
        return new MultiDataSourceContextHolder();
    }

    @Bean
    public DialectBeanFactoryPostProcessor dialectBeanFactoryPostProcessor() {
        return new DialectBeanFactoryPostProcessor();
    }
}

