/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.jakarta.StatViewServlet;
import com.alibaba.druid.support.jakarta.WebStatFilter;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.config.Dialect;
import com.cyberway.mp.bc.dal.datasource.DruidDataSourceProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.alibaba.druid.pool.DruidDataSource", matchIfMissing=false)
@EnableConfigurationProperties(value={DruidDataSourceProperties.class, DALProperties.class})
public class DruidDataSourceConfig {
    @Bean
    public DruidDataSource dataSource(DataSourceProperties dataSourceProperties, DruidDataSourceProperties druidDataSourceProperties, DALProperties dalProperties) {
        DruidDataSource druidDataSource = (DruidDataSource)dataSourceProperties.initializeDataSourceBuilder().type(DruidDataSource.class).build();
        druidDataSource.configFromPropety(druidDataSourceProperties.toProperties());
        druidDataSource.setInitialSize(druidDataSourceProperties.getInitialSize().intValue());
        druidDataSource.setMinIdle(druidDataSourceProperties.getMinIdle().intValue());
        druidDataSource.setMaxActive(druidDataSourceProperties.getMaxActive().intValue());
        druidDataSource.setMaxWait(druidDataSourceProperties.getMaxWait().longValue());
        druidDataSource.setConnectProperties(druidDataSourceProperties.getConnectionProperties());
        ArrayList<String> initSqls = new ArrayList<String>();
        if (dalProperties.getDialect().equalsIgnoreCase(Dialect.MYSQL.name())) {
            initSqls.add("set names utf8mb4;");
        }
        druidDataSource.setConnectionInitSqls(initSqls);
        return druidDataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletRegistrationBean druidStatViewServlet(DruidDataSourceProperties druidDataSourceProperties) {
        return new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
    }

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean druidWebStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid2/*");
        return filterRegistrationBean;
    }
}

