/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.datasource.multi;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.config.multi.DataSourceProperty;
import com.cyberway.mp.bc.dal.datasource.multi.DataSourceCreator;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class DataSourceCreatorFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final Map<String, DataSourceCreator> typeToCreator = new HashMap<String, DataSourceCreator>();

    public DataSourceCreatorFactory(DALProperties dalProperties) {
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        DataSourceCreator creator;
        Map customCreatorMap = this.applicationContext.getBeansOfType(DataSourceCreator.class);
        if (!CollectionUtils.isEmpty((Map)customCreatorMap)) {
            for (DataSourceCreator dataSourceCreator : customCreatorMap.values()) {
                this.typeToCreator.put(dataSourceCreator.supportType(), dataSourceCreator);
            }
        }
        if ((creator = this.typeToCreator.get(dataSourceProperty.getType())) == null) {
            throw new BaseException("00000002", String.format("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e\u5e93\u8fde\u63a5\u6c60: %s", dataSourceProperty.getType()));
        }
        return creator.createDataSource(dataSourceProperty);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

