/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.datasource.multi;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.MultiDataSourceHolder;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.NamedThreadLocal;

public class MultiDataSourceContextHolder
implements MultiDataSourceHolder {
    private static final ThreadLocal<Deque<String>> HOLDER = new NamedThreadLocal<Deque<String>>("multi-datasource"){

        protected Deque<String> initialValue() {
            return new ArrayDeque<String>();
        }
    };

    public static String peek() {
        return HOLDER.get().peek();
    }

    public static String push(String ds) {
        if (StringUtils.isEmpty((CharSequence)ds)) {
            throw new BaseException("00000002", "\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HOLDER.get().push(ds);
        return ds;
    }

    public static void poll() {
        Deque<String> deque = HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            HOLDER.remove();
        }
    }

    @Override
    public String currentDataSource() {
        return MultiDataSourceContextHolder.peek();
    }

    @Override
    public void setCurrentDataSource(String dataSource) {
        MultiDataSourceContextHolder.push(dataSource);
    }
}

