/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.datasource.multi;

import com.alibaba.druid.pool.DruidDataSource;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.config.multi.DataSourceProperty;
import com.cyberway.mp.bc.dal.datasource.multi.DataSourceCreatorFactory;
import com.cyberway.mp.bc.dal.datasource.multi.MultiDataSourceContextHolder;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.StringUtils;

public class RoutingDataSource
extends AbstractDataSource
implements InitializingBean,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(RoutingDataSource.class);
    public static final String DEFAULT_DATASOURCE = "default";
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private DALProperties dalProperties;
    private DataSourceCreatorFactory dataSourceCreatorFactory;

    public RoutingDataSource(DALProperties dalProperties, DataSourceCreatorFactory dataSourceCreatorFactory) {
        this.dalProperties = dalProperties;
        this.dataSourceCreatorFactory = dataSourceCreatorFactory;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    private DataSource getDataSource() {
        String ds = MultiDataSourceContextHolder.peek();
        ds = StringUtils.hasLength((String)ds) ? ds : DEFAULT_DATASOURCE;
        DataSource dataSource = this.dataSourceMap.get(ds);
        if (dataSource == null) {
            throw new BaseException("00000001", "\u627e\u4e0d\u5230\u6570\u636e\u6e90");
        }
        return dataSource;
    }

    public DataSource getDataSource(String dataSourceName) {
        DataSource dataSource = this.dataSourceMap.get(dataSourceName);
        if (dataSource == null) {
            throw new BaseException("00000001", "\u627e\u4e0d\u5230\u6570\u636e\u6e90");
        }
        return dataSource;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.getDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance((Object)this) || this.getDataSource().isWrapperFor(iface);
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, DataSource> item : this.dataSourceMap.entrySet()) {
            this.closeDataSource(item.getKey(), item.getValue());
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (Map.Entry<String, DataSourceProperty> entry : this.dalProperties.getMultiDatasource().entrySet()) {
            DataSource dataSource = this.dataSourceCreatorFactory.createDataSource(entry.getValue());
            this.addDataSource(entry.getKey(), dataSource);
        }
        this.validtorHasDefaultSource();
    }

    private void validtorHasDefaultSource() {
        boolean findDefault = false;
        for (String key : this.dataSourceMap.keySet()) {
            if (!DEFAULT_DATASOURCE.equalsIgnoreCase(key)) continue;
            findDefault = true;
        }
        if (!findDefault) {
            throw new BaseException("00000001", "\u6ca1\u6709default\u6570\u636e\u6e90");
        }
    }

    private synchronized void addDataSource(String ds, DataSource dataSource) {
        DataSource oldDataSource = this.dataSourceMap.put(ds, dataSource);
        if (oldDataSource != null) {
            this.closeDataSource(ds, oldDataSource);
        }
    }

    private void closeDataSource(String ds, DataSource dataSource) {
        try {
            if (dataSource instanceof DruidDataSource) {
                ((DruidDataSource)dataSource).close();
            } else if (dataSource instanceof HikariDataSource) {
                ((HikariDataSource)dataSource).close();
            }
        }
        catch (Exception e) {
            this.log.error("RoutingDataSource closed datasource named [{}] failed", (Object)ds, (Object)e);
        }
    }
}

