/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.datasource.multi.aop;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.annotation.MultiDataSource;
import com.cyberway.mp.bc.dal.datasource.multi.MultiDataSourceContextHolder;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final Logger log;
    private static Field mapperInterfaceField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        MultiDataSource multiDataSource = invocation.getMethod().getAnnotation(MultiDataSource.class);
        if (multiDataSource == null) {
            multiDataSource = this.findMapperAnnotation(invocation);
        }
        MultiDataSourceContextHolder.push(multiDataSource.value());
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            MultiDataSourceContextHolder.poll();
        }
    }

    private MultiDataSource findMapperAnnotation(MethodInvocation invocation) throws IllegalAccessException {
        InvocationHandler handler = EntityUtils.resolverProxyInvocation(invocation.getThis());
        Class mapper = (Class)mapperInterfaceField.get(handler);
        return mapper.getAnnotation(MultiDataSource.class);
    }

    static {
        Class<?> proxyClass;
        log = LoggerFactory.getLogger(MultiDataSourceAnnotationInterceptor.class);
        try {
            proxyClass = Class.forName("org.apache.ibatis.binding.MapperProxy");
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u83b7\u53d6\u7c7b\u5931\u8d25\uff0c\u7c7b\u4e0d\u5b58\u5728");
        }
        try {
            mapperInterfaceField = proxyClass.getDeclaredField("mapperInterface");
            mapperInterfaceField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", "\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25\uff0c\u6ca1\u6709\u6b64\u5b57\u6bb5");
        }
    }
}

