/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.datasource.multi.creator;

import com.alibaba.druid.pool.DruidDataSource;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.config.Dialect;
import com.cyberway.mp.bc.dal.config.multi.DataSourceProperty;
import com.cyberway.mp.bc.dal.datasource.DruidDataSourceProperties;
import com.cyberway.mp.bc.dal.datasource.multi.DataSourceCreator;
import java.util.ArrayList;
import javax.sql.DataSource;

public class DruidDataSourceCreator
implements DataSourceCreator {
    private DALProperties dalProperties;

    public DruidDataSourceCreator(DALProperties dalProperties) {
        this.dalProperties = dalProperties;
    }

    @Override
    public String supportType() {
        return DruidDataSource.class.getTypeName();
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        DruidDataSource druidDataSource = new DruidDataSource();
        DruidDataSourceProperties druidDataSourceProperties = dataSourceProperty.getDruid();
        druidDataSource.configFromPropety(druidDataSourceProperties.toProperties());
        druidDataSource.setInitialSize(druidDataSourceProperties.getInitialSize().intValue());
        druidDataSource.setMinIdle(druidDataSourceProperties.getMinIdle().intValue());
        druidDataSource.setMaxActive(druidDataSourceProperties.getMaxActive().intValue());
        druidDataSource.setMaxWait(druidDataSourceProperties.getMaxWait().longValue());
        druidDataSource.setConnectProperties(druidDataSourceProperties.getConnectionProperties());
        druidDataSource.setUsername(dataSourceProperty.getUsername());
        druidDataSource.setPassword(dataSourceProperty.getPassword());
        druidDataSource.setUrl(dataSourceProperty.getUrl());
        druidDataSource.setDriverClassName(dataSourceProperty.getDriverClassName());
        ArrayList<String> initSqls = new ArrayList<String>();
        if (dataSourceProperty.getDialect().equalsIgnoreCase(Dialect.MYSQL.name())) {
            initSqls.add("set names utf8mb4;");
        }
        druidDataSource.setConnectionInitSqls(initSqls);
        return druidDataSource;
    }
}

