/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.dynamicquery;

import com.cyberway.mp.bc.dal.dynamicquery.ColExpression;
import com.cyberway.mp.bc.dal.dynamicquery.Expression;
import com.cyberway.mp.bc.dal.dynamicquery.FromExp;
import com.cyberway.mp.bc.dal.dynamicquery.JoinExp;
import com.cyberway.mp.bc.dal.dynamicquery.QueryVisitor;
import com.cyberway.mp.bc.dal.dynamicquery.TableExp;
import com.cyberway.mp.bc.dal.dynamicquery.ValExpression;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import java.util.ArrayList;
import java.util.List;

public class DynamicQuery {
    private List<FromExp> from = new ArrayList<FromExp>();
    private List<Expression> where = new ArrayList<Expression>();
    private List<OrderFragment> orderBy = new ArrayList<OrderFragment>();
    private List<ColExpression> groupBy = new ArrayList<ColExpression>();
    private List<Expression> having = new ArrayList<Expression>();
    private List<String> allows = new ArrayList<String>();
    public static final String WHERE_FIELD_NAME = "where";
    public static final String HAVING_FIELD_NAME = "having";

    public DynamicQuery from(TableExp tableExp) {
        this.from.add(tableExp);
        return this;
    }

    public DynamicQuery from(JoinExp joinExp) {
        this.from.add(joinExp);
        return this;
    }

    public DynamicQuery addWhere(Expression filter) {
        this.where.add(filter);
        return this;
    }

    public DynamicQuery table(String tableName) {
        TableExp tableExp = TableExp.table(tableName);
        return this.from(tableExp);
    }

    public DynamicQuery join(String left, String right) {
        TableExp leftTable = TableExp.table(left);
        TableExp rightTable = TableExp.table(right);
        return this.from(JoinExp.join(leftTable, rightTable));
    }

    public DynamicQuery leftJoin(String left, String right) {
        TableExp leftTable = TableExp.table(left);
        TableExp rightTable = TableExp.table(right);
        return this.from(JoinExp.leftJoin(leftTable, rightTable));
    }

    public DynamicQuery rightJoin(String left, String right) {
        TableExp leftTable = TableExp.table(left);
        TableExp rightTable = TableExp.table(right);
        return this.from(JoinExp.rightJoin(leftTable, rightTable));
    }

    public DynamicQuery sqlEqual(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.sqlEqual(colExpression, valExpression));
    }

    public DynamicQuery notEqual(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.notEqual(colExpression, valExpression));
    }

    public DynamicQuery between(String col, Object startVal, Object endVal) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression startValExpression = ValExpression.from(startVal);
        ValExpression endValExpression = ValExpression.from(endVal);
        Expression andExpression = Expression.and(startValExpression, endValExpression);
        return this.addWhere(Expression.between(colExpression, andExpression));
    }

    public DynamicQuery isNotNull(String col) {
        ColExpression colExpression = ColExpression.col(col);
        return this.addWhere(Expression.isNotNull(colExpression));
    }

    public DynamicQuery isNull(String col) {
        ColExpression colExpression = ColExpression.col(col);
        return this.addWhere(Expression.isNull(colExpression));
    }

    public DynamicQuery lessThan(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.lessThan(colExpression, valExpression));
    }

    public DynamicQuery lessThanEqual(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.lessThanEqual(colExpression, valExpression));
    }

    public DynamicQuery greaterThan(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.greaterThan(colExpression, valExpression));
    }

    public DynamicQuery greaterThanEqual(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.greaterThanEqual(colExpression, valExpression));
    }

    public DynamicQuery notLike(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.notLike(colExpression, valExpression));
    }

    public DynamicQuery like(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.like(colExpression, valExpression));
    }

    public DynamicQuery startingWith(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.startingWith(colExpression, valExpression));
    }

    public DynamicQuery endWith(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.endWith(colExpression, valExpression));
    }

    public DynamicQuery notContain(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.notContain(colExpression, valExpression));
    }

    public DynamicQuery contain(String col, Object colValue) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValue);
        return this.addWhere(Expression.contain(colExpression, valExpression));
    }

    public DynamicQuery notIn(String col, List<Object> colValues) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValues);
        return this.addWhere(Expression.notIn(colExpression, valExpression));
    }

    public DynamicQuery in(String col, List<Object> colValues) {
        ColExpression colExpression = ColExpression.col(col);
        ValExpression valExpression = ValExpression.from(colValues);
        return this.addWhere(Expression.in(colExpression, valExpression));
    }

    public DynamicQuery sqlTrue(String col) {
        ColExpression colExpression = ColExpression.col(col);
        return this.addWhere(Expression.sqlTrue(colExpression));
    }

    public DynamicQuery sqlFalse(String col) {
        ColExpression colExpression = ColExpression.col(col);
        return this.addWhere(Expression.sqlFalse(colExpression));
    }

    public DynamicQuery addOrder(OrderFragment order) {
        this.orderBy.add(order);
        return this;
    }

    public DynamicQuery addGroupBy(ColExpression group) {
        this.groupBy.add(group);
        return this;
    }

    public DynamicQuery addHaving(Expression havingFilter) {
        this.having.add(havingFilter);
        return this;
    }

    public DynamicQuery addAllow(String allow) {
        this.allows.add(allow);
        return this;
    }

    public List<FromExp> getFrom() {
        return this.from;
    }

    public void setFrom(List<FromExp> from) {
        this.from = from;
    }

    public List<Expression> getWhere() {
        return this.where;
    }

    public void setWhere(List<Expression> where) {
        this.where = where;
    }

    public List<OrderFragment> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<OrderFragment> orderBy) {
        this.orderBy = orderBy;
    }

    public List<ColExpression> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<ColExpression> groupBy) {
        this.groupBy = groupBy;
    }

    public List<Expression> getHaving() {
        return this.having;
    }

    public void setHaving(List<Expression> having) {
        this.having = having;
    }

    public List<String> getAllows() {
        return this.allows;
    }

    public void setAllows(List<String> allows) {
        this.allows = allows;
    }

    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }
}

