/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.dynamicquery;

import com.cyberway.mp.bc.dal.dynamicquery.ExpressionType;
import com.cyberway.mp.bc.dal.dynamicquery.QueryVisitor;

public class Expression {
    protected ExpressionType expressionType;
    private Expression left;
    private Expression right;
    private boolean hasParentheses = false;
    public static final String LEFT_FIELD_NAME = "left";
    public static final String RIGHT_FIELD_NAME = "right";

    public Expression() {
    }

    private Expression(Expression left, Expression right, ExpressionType expressionType) {
        this.left = left;
        this.right = right;
        this.expressionType = expressionType;
    }

    private Expression(Expression left, Expression right, ExpressionType expressionType, boolean hasParentheses) {
        this(left, right, expressionType);
        this.hasParentheses = hasParentheses;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionType expressionType) {
        this.expressionType = expressionType;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    public boolean isHasParentheses() {
        return this.hasParentheses;
    }

    public void setHasParentheses(boolean hasParentheses) {
        this.hasParentheses = hasParentheses;
    }

    public static Expression and(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.AND);
    }

    public static Expression and(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.AND, hasParentheses);
    }

    public static Expression or(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.OR);
    }

    public static Expression or(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.OR, hasParentheses);
    }

    public static Expression sqlEqual(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.EQUAL);
    }

    public static Expression sqlEqual(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.EQUAL, hasParentheses);
    }

    public static Expression notEqual(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.NOT_EQUAL);
    }

    public static Expression notEqual(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.NOT_EQUAL, hasParentheses);
    }

    public static Expression between(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.BETWEEN);
    }

    public static Expression between(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.BETWEEN, hasParentheses);
    }

    public static Expression isNotNull(Expression left) {
        return new Expression(left, null, ExpressionType.IS_NOT_NULL);
    }

    public static Expression isNotNull(Expression left, boolean hasParentheses) {
        return new Expression(left, null, ExpressionType.IS_NOT_NULL, hasParentheses);
    }

    public static Expression isNull(Expression left) {
        return new Expression(left, null, ExpressionType.IS_NULL);
    }

    public static Expression isNull(Expression left, boolean hasParentheses) {
        return new Expression(left, null, ExpressionType.IS_NULL, hasParentheses);
    }

    public static Expression lessThan(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.LESS_THAN);
    }

    public static Expression lessThan(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.LESS_THAN, hasParentheses);
    }

    public static Expression lessThanEqual(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.LESS_THAN_EQUAL);
    }

    public static Expression lessThanEqual(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.LESS_THAN_EQUAL, hasParentheses);
    }

    public static Expression greaterThan(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.GREATER_THAN);
    }

    public static Expression greaterThan(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.GREATER_THAN, hasParentheses);
    }

    public static Expression greaterThanEqual(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.GREATER_THAN_EQUAL);
    }

    public static Expression greaterThanEqual(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.GREATER_THAN_EQUAL, hasParentheses);
    }

    public static Expression notLike(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.NOT_LIKE);
    }

    public static Expression notLike(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.NOT_LIKE, hasParentheses);
    }

    public static Expression like(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.LIKE);
    }

    public static Expression like(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.LIKE, hasParentheses);
    }

    public static Expression startingWith(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.STARTING_WITH);
    }

    public static Expression startingWith(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.STARTING_WITH, hasParentheses);
    }

    public static Expression endWith(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.ENDING_WITH);
    }

    public static Expression endWith(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.ENDING_WITH, hasParentheses);
    }

    public static Expression notContain(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.NOT_CONTAINING);
    }

    public static Expression notContain(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.NOT_CONTAINING, hasParentheses);
    }

    public static Expression contain(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.CONTAINING);
    }

    public static Expression contain(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.CONTAINING, hasParentheses);
    }

    public static Expression notIn(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.NOT_IN);
    }

    public static Expression notIn(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.NOT_IN, hasParentheses);
    }

    public static Expression in(Expression left, Expression right) {
        return new Expression(left, right, ExpressionType.IN);
    }

    public static Expression in(Expression left, Expression right, boolean hasParentheses) {
        return new Expression(left, right, ExpressionType.IN, hasParentheses);
    }

    public static Expression sqlTrue(Expression left) {
        return new Expression(left, null, ExpressionType.TRUE);
    }

    public static Expression sqlTrue(Expression left, boolean hasParentheses) {
        return new Expression(left, null, ExpressionType.TRUE, hasParentheses);
    }

    public static Expression sqlFalse(Expression left) {
        return new Expression(left, null, ExpressionType.FALSE);
    }

    public static Expression sqlFalse(Expression left, boolean hasParentheses) {
        return new Expression(left, null, ExpressionType.FALSE, hasParentheses);
    }

    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }
}

