/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.dynamicquery;

public enum ExpressionType {
    AND(" and "),
    OR(" or "),
    EQUAL(" = "),
    NOT_EQUAL(" != "),
    BETWEEN(" between "),
    IS_NOT_NULL(" is not null "),
    IS_NULL(" is null "),
    LESS_THAN(" < "),
    LESS_THAN_EQUAL(" <= "),
    GREATER_THAN(" > "),
    GREATER_THAN_EQUAL(" >= "),
    NOT_LIKE(" not like "),
    LIKE(" like "),
    STARTING_WITH("  like CONCAT(", ",'%') "),
    ENDING_WITH("   like CONCAT('%',", ") "),
    NOT_CONTAINING("  not like CONCAT(CONCAT( '%',", "),  '%') "),
    CONTAINING(" like CONCAT(CONCAT( '%',", "),  '%') "),
    NOT_IN(" not in ", "<foreach item='item' index='index' collection='", "' open='(' separator=',' close=')'>#{item}</foreach> "),
    IN(" in ", "<foreach item='item' index='index' collection='", "' open='(' separator=',' close=')'>#{item}</foreach> "),
    TRUE("  = true "),
    FALSE(" = false "),
    COL(""),
    VAL("");

    private final String sqlFrame;
    private final String prefix;
    private final String postfix;

    private ExpressionType(String sqlFrame, String prefix, String postfix) {
        this.sqlFrame = sqlFrame;
        this.postfix = postfix;
        this.prefix = prefix;
    }

    private ExpressionType(String sqlFrame) {
        this(sqlFrame, null, null);
    }

    private ExpressionType(String sqlFrame, String postfix) {
        this(sqlFrame, null, postfix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public boolean hasPostfix() {
        return this.postfix != null;
    }

    public String getSqlFrame() {
        return this.sqlFrame;
    }
}

