/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.dynamicquery;

import com.cyberway.mp.bc.dal.dynamicquery.Expression;
import com.cyberway.mp.bc.dal.dynamicquery.FromExp;
import com.cyberway.mp.bc.dal.dynamicquery.JoinType;
import com.cyberway.mp.bc.dal.dynamicquery.NodeType;
import com.cyberway.mp.bc.dal.dynamicquery.QueryVisitor;
import com.cyberway.mp.bc.dal.dynamicquery.TableExp;

public class JoinExp
extends FromExp {
    private TableExp left;
    private TableExp right;
    private JoinType joinType;
    private Expression onExpression;

    public JoinExp() {
        super(NodeType.JOIN);
    }

    private JoinExp(TableExp left, TableExp right, JoinType joinType, Expression onExpression) {
        super(NodeType.JOIN);
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.onExpression = onExpression;
    }

    private JoinExp(TableExp left, TableExp right, JoinType joinType) {
        this(left, right, joinType, null);
    }

    public static JoinExp join(TableExp left, TableExp right) {
        return new JoinExp(left, right, JoinType.JOIN);
    }

    public static JoinExp join(TableExp left, TableExp right, Expression onExpression) {
        return new JoinExp(left, right, JoinType.JOIN, onExpression);
    }

    public static JoinExp leftJoin(TableExp left, TableExp right) {
        return new JoinExp(left, right, JoinType.LEFT_JOIN);
    }

    public static JoinExp leftJoin(TableExp left, TableExp right, Expression onExpression) {
        return new JoinExp(left, right, JoinType.LEFT_JOIN, onExpression);
    }

    public static JoinExp rightJoin(TableExp left, TableExp right) {
        return new JoinExp(left, right, JoinType.RIGHT_JOIN);
    }

    public static JoinExp rightJoin(TableExp left, TableExp right, Expression onExpression) {
        return new JoinExp(left, right, JoinType.RIGHT_JOIN, onExpression);
    }

    public TableExp getLeft() {
        return this.left;
    }

    public TableExp getRight() {
        return this.right;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setLeft(TableExp left) {
        this.left = left;
    }

    public void setRight(TableExp right) {
        this.right = right;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public void setOnExpression(Expression onExpression) {
        this.onExpression = onExpression;
    }

    public Expression getOnExpression() {
        return this.onExpression;
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }
}

