/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.dynamicquery;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.dynamicquery.ColExpression;
import com.cyberway.mp.bc.dal.dynamicquery.DynamicQuery;
import com.cyberway.mp.bc.dal.dynamicquery.Expression;
import com.cyberway.mp.bc.dal.dynamicquery.FromExp;
import com.cyberway.mp.bc.dal.dynamicquery.JoinExp;
import com.cyberway.mp.bc.dal.dynamicquery.QueryVisitor;
import com.cyberway.mp.bc.dal.dynamicquery.Scope;
import com.cyberway.mp.bc.dal.dynamicquery.TableExp;
import com.cyberway.mp.bc.dal.dynamicquery.ValExpression;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuerySqlGen
implements QueryVisitor {
    private static final String REG = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";
    private Pattern preventSQLPrevent = Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)", 2);
    private final StringBuilder sqlStringBuilder = new StringBuilder();
    private List<String> allows = new ArrayList<String>();
    private final Scope rootScope;
    private Scope currentScope;
    private final boolean isCount;
    private SqlEscape sqlEscape;

    public QuerySqlGen(String rootParamName, SqlEscape sqlEscape) {
        this(rootParamName, false, sqlEscape);
    }

    public QuerySqlGen(String rootParamName, boolean isCount, SqlEscape sqlEscape) {
        this.currentScope = this.rootScope = new Scope(null, rootParamName);
        this.isCount = isCount;
        this.sqlEscape = sqlEscape;
    }

    @Override
    public void visit(DynamicQuery dynamicQuery) {
        List<OrderFragment> orderBy;
        List<ColExpression> groupBy;
        this.allows = dynamicQuery.getAllows();
        List<FromExp> from = dynamicQuery.getFrom();
        if (from.isEmpty()) {
            throw new BaseException("00000002", "\u52a8\u6001SQL\u5fc5\u987b\u6709from\u67e5\u8be2\u8868");
        }
        this.handlerFrom(from);
        List<Expression> where = dynamicQuery.getWhere();
        if (!where.isEmpty()) {
            this.handlerWhere(where);
        }
        if (!(groupBy = dynamicQuery.getGroupBy()).isEmpty()) {
            this.handlerGroupBy(groupBy);
            List<Expression> having = dynamicQuery.getHaving();
            if (!having.isEmpty()) {
                this.handlerHaving(having);
            }
        }
        if (!(orderBy = dynamicQuery.getOrderBy()).isEmpty() && !this.isCount) {
            this.handlerOrderBy(orderBy);
        }
    }

    private void handlerFrom(List<FromExp> from) {
        this.sqlStringBuilder.append(" from ");
        int fromTableCount = 0;
        for (FromExp fromExp : from) {
            if (fromTableCount > 0) {
                this.sqlStringBuilder.append(",");
            }
            fromExp.accept(this);
            ++fromTableCount;
        }
    }

    private void handlerWhere(List<Expression> where) {
        this.sqlStringBuilder.append(" where ");
        for (int i = 0; i < where.size(); ++i) {
            if (i > 0) {
                this.sqlStringBuilder.append(" and ");
            }
            this.currentScope = new Scope(this.currentScope, "where[" + i + "]");
            where.get(i).accept(this);
            this.currentScope = this.currentScope.getParentScope();
        }
    }

    private void handlerGroupBy(List<ColExpression> groupBy) {
        this.sqlStringBuilder.append(" group by ");
        int groupByCount = 0;
        for (ColExpression col : groupBy) {
            if (groupByCount > 0) {
                this.sqlStringBuilder.append(",");
            }
            col.accept(this);
            ++groupByCount;
        }
    }

    private void handlerHaving(List<Expression> having) {
        this.sqlStringBuilder.append(" having ");
        for (int i = 0; i < having.size(); ++i) {
            if (i > 0) {
                this.sqlStringBuilder.append(" and ");
            }
            this.currentScope = new Scope(this.currentScope, "having[" + i + "]");
            having.get(i).accept(this);
            this.currentScope = this.currentScope.getParentScope();
        }
    }

    private void handlerOrderBy(List<OrderFragment> orderBy) {
        this.sqlStringBuilder.append(" order by ");
        int orderCount = 0;
        for (OrderFragment order : orderBy) {
            if (orderCount > 0) {
                this.sqlStringBuilder.append(",");
            }
            this.sqlStringBuilder.append(this.sqlEscape.escapeColName(order.getFieldName()));
            this.sqlStringBuilder.append(" ");
            this.sqlStringBuilder.append(order.getDirection());
            ++orderCount;
        }
    }

    @Override
    public void visit(Expression expression) {
        if (expression.isHasParentheses()) {
            this.sqlStringBuilder.append(" ( ");
        }
        this.handlerCommonExp(expression);
        if (expression.isHasParentheses()) {
            this.sqlStringBuilder.append(" ) ");
        }
    }

    private void handlerCommonExp(Expression expression) {
        Expression left = expression.getLeft();
        this.currentScope = new Scope(this.currentScope, "left");
        left.accept(this);
        this.currentScope = this.currentScope.getParentScope();
        this.sqlStringBuilder.append(expression.expressionType.getSqlFrame());
        Expression right = expression.getRight();
        if (right == null) {
            return;
        }
        if (expression.getExpressionType().hasPrefix()) {
            this.sqlStringBuilder.append(expression.getExpressionType().getPrefix());
        }
        this.acceptExp(right);
        if (expression.getExpressionType().hasPostfix()) {
            this.sqlStringBuilder.append(expression.getExpressionType().getPostfix());
        }
    }

    private void acceptExp(Expression right) {
        this.currentScope = new Scope(this.currentScope, "right");
        right.accept(this);
        this.currentScope = this.currentScope.getParentScope();
    }

    @Override
    public void visit(JoinExp joinExp) {
        joinExp.getLeft().accept(this);
        this.sqlStringBuilder.append(joinExp.getJoinType().getJoinTypeName());
        joinExp.getRight().accept(this);
        if (joinExp.getOnExpression() != null) {
            this.sqlStringBuilder.append(" on ");
            joinExp.getOnExpression().accept(this);
        }
    }

    @Override
    public void visit(TableExp tableExp) {
        this.sqlStringBuilder.append(" ");
        this.sqlStringBuilder.append(tableExp.getName());
        this.sqlStringBuilder.append(" ");
        if (tableExp.getAliasName() != null) {
            this.sqlStringBuilder.append("as ");
            this.sqlStringBuilder.append(tableExp.getAliasName());
            this.sqlStringBuilder.append(" ");
        }
    }

    @Override
    public void visit(ValExpression valExpression) {
        this.sqlStringBuilder.append("#{");
        this.sqlStringBuilder.append(this.rootScope.constructValPath());
        this.sqlStringBuilder.append("val");
        this.sqlStringBuilder.append("}");
    }

    @Override
    public void visit(ColExpression colExpression) {
        if (!this.allows.isEmpty() && !this.allows.contains(colExpression.getColName())) {
            throw new BaseException("00000002", "\u5b57\u6bb5:" + colExpression.getColName() + "\u4e0d\u80fd\u7528\u4e8e\u67e5\u8be2\u6761\u4ef6");
        }
        this.preventSQLInject(colExpression.getColName());
        this.sqlStringBuilder.append(" ");
        this.sqlStringBuilder.append(this.sqlEscape.escapeColName(colExpression.getColName()));
        this.sqlStringBuilder.append(" ");
    }

    private void preventSQLInject(String colName) {
        Matcher matcher = this.preventSQLPrevent.matcher(colName);
        if (matcher.find()) {
            throw new BaseException("00000002", "\u5b57\u6bb5:" + colName + "\u53c2\u6570\u5b58\u5728\u975e\u6cd5\u5b57\u7b26:" + matcher.group());
        }
    }

    public String getSql() {
        return this.sqlStringBuilder.toString();
    }
}

