/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.NullableField;
import com.cyberway.mp.bc.dal.annotation.Or;
import com.cyberway.mp.bc.dal.annotation.OrderBy;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.dynamicquery.DynamicQuery;
import com.cyberway.mp.bc.dal.generate.InterceptSqlGenerator;
import com.cyberway.mp.bc.dal.generate.QueryMergeParam;
import com.cyberway.mp.bc.dal.generate.SqlGenerator;
import com.cyberway.mp.bc.dal.generate.parser.Column;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.Predicate;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractSqlGenerator
implements SqlGenerator,
InterceptSqlGenerator {
    private static final String AS = " as ";
    protected static final String SCRIPT_TEMPLATE = "<script>%s</script>";
    protected static final String DEFAULT_ORDER_BY = " order by id ";
    private static final Logger log = LoggerFactory.getLogger(AbstractSqlGenerator.class);
    @Autowired
    protected DALProperties dalProperties;
    @Autowired
    protected SqlEscape sqlEscape;

    public void setDalProperties(DALProperties dalProperties) {
        this.dalProperties = dalProperties;
    }

    public void setSqlEscape(SqlEscape sqlEscape) {
        this.sqlEscape = sqlEscape;
    }

    protected String findTableName(com.cyberway.mp.bc.dal.annotation.Predicate predicate, String entityName, Table table) {
        if (predicate != null && StringUtils.isNotEmpty((CharSequence)predicate.tableName())) {
            return predicate.tableName();
        }
        if (table != null && StringUtils.isNotEmpty((CharSequence)table.name())) {
            return table.name();
        }
        return Strings.underscoreName((String)entityName);
    }

    protected Field[] getEntityFields(Class<?> entityClass) {
        return FieldUtils.getAllFields(entityClass);
    }

    protected List<Field> getEntityNotStaticAndNotNullFields(Object entity) {
        return this.getEntityNotStaticFields(entity, true);
    }

    protected List<Field> getEntityNotStaticFields(Object entity, boolean ignoreNullValueField) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getEntityFields(entity.getClass())) {
            Object value;
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                value = FieldUtils.readField((Object)entity, (String)field.getName(), (boolean)true);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BaseException("00000001", "\u83b7\u53d6entity\u5b57\u6bb5\u5931\u8d25");
            }
            if (ignoreNullValueField && value == null && null == AnnotationUtils.findAnnotation((AnnotatedElement)field, NullableField.class) || value instanceof String && ((String)value).length() == 0 && !field.isAnnotationPresent(Or.class) && field.isAnnotationPresent(Contains.class)) continue;
            fields.add(field);
        }
        return fields;
    }

    protected List<Field> getOrderFields(Object entity) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getEntityFields(entity.getClass())) {
            if (!Modifier.isStatic(field.getModifiers()) && field.getAnnotation(OrderBy.class) != null) {
                fields.add(field);
            }
            if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(OrderByField.class) == null) continue;
            fields.add(field);
        }
        return fields;
    }

    protected boolean isLogicDeleted(Class<?> entityClass) {
        LogicDelete logicDelete = (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class);
        return logicDelete != null;
    }

    protected String findLogicDeletedFieldName(Class<?> entityClass) {
        LogicDelete logicDelete = (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class);
        if (logicDelete == null) {
            throw new BaseException("00000001", "\u5b9e\u4f53\u627e\u4e0d\u5230\u903b\u8f91\u5220\u9664\u6807\u8bb0");
        }
        return logicDelete.fieldName();
    }

    @Override
    public boolean match(String methodName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object target, String sqlFrame) {
        throw new UnsupportedOperationException();
    }

    protected List<String> cols(MethodParserResult result) {
        ArrayList<String> colStrings = new ArrayList<String>();
        for (Column column : result.getBeanColumn().getColumns()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)column.getAlias())) {
                stringBuilder.append(this.sqlEscape.escapeColName(Strings.underscoreName((String)column.getName())));
            } else {
                stringBuilder.append(this.sqlEscape.escapeColName(column.getAlias()));
            }
            stringBuilder.append(AS);
            stringBuilder.append(this.sqlEscape.escapeColName(column.getName(), true));
            colStrings.add(stringBuilder.toString());
        }
        return colStrings;
    }

    protected Predicate mergePredicate(Object query, boolean isNeedEntity, String entityPrefix, boolean isSearch) {
        List<Field> fields = this.getEntityNotStaticAndNotNullFields(query);
        List<Field> orderFields = Collections.emptyList();
        if (isSearch) {
            orderFields = this.getOrderFields(query);
        }
        if (!fields.isEmpty()) {
            return new Predicate(fields, isNeedEntity, entityPrefix, orderFields, true, query, this.sqlEscape);
        }
        return null;
    }

    protected Object findQueryObject(Object target) {
        if (target instanceof Map) {
            return this.findQueryObjectInMap(target);
        }
        if (target.getClass().getAnnotation(com.cyberway.mp.bc.dal.annotation.Predicate.class) != null) {
            return target;
        }
        return null;
    }

    private Object findQueryObjectInMap(Object target) {
        Object query = null;
        Map paramMap = (Map)target;
        for (Object value : paramMap.values()) {
            if (value.getClass().getAnnotation(com.cyberway.mp.bc.dal.annotation.Predicate.class) == null) continue;
            query = value;
        }
        return query;
    }

    protected SqlCommand noneSearchQueryBeanMerge(QueryMergeParam queryMergeParam) {
        StringBuilder stringBuilder = new StringBuilder();
        Object queryObject = this.findQueryObject(queryMergeParam.getTarget());
        Predicate predicate = null;
        if (queryObject != null && (predicate = this.mergePredicate(queryObject, false, null, false)) != null) {
            stringBuilder.append(predicate.toSqlFrame(predicate.hasScript()));
        }
        Object sql = queryMergeParam.getSqlFrame() + stringBuilder;
        if (predicate != null && predicate.hasScript()) {
            sql = String.format(SCRIPT_TEMPLATE, sql);
        }
        return new SqlCommand((String)sql, queryMergeParam.getSqlCommandType());
    }

    protected boolean hasQueryBean(Method method, Class<?> mapper) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i, i + 1);
            Class aClass = methodParameter.withContainingClass(mapper).getParameterType();
            com.cyberway.mp.bc.dal.annotation.Predicate predicate = aClass.getAnnotation(com.cyberway.mp.bc.dal.annotation.Predicate.class);
            if (predicate == null) continue;
            return true;
        }
        return false;
    }

    protected String findPageParamName(Object myBaitsParams) {
        Map paramMap = (Map)myBaitsParams;
        for (Map.Entry each : paramMap.entrySet()) {
            if (!(each.getValue() instanceof PageParam)) continue;
            return (String)each.getKey();
        }
        throw new IllegalArgumentException("find \u5206\u9875\u65b9\u6cd5\u627e\u4e0d\u5230\u5206\u9875\u53c2\u6570");
    }

    protected boolean needAddDefaultOrderBy(boolean hasPage, String ... sqlFrames) {
        if (hasPage && this.dalProperties.currentDialectIsSqlServer()) {
            if (null != sqlFrames) {
                for (String sqlFrame : sqlFrames) {
                    if (null == sqlFrame || !sqlFrame.toUpperCase().contains(" ORDER BY ")) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isDynamicQuery(Method method) {
        Type[] params;
        for (Type type : params = method.getGenericParameterTypes()) {
            if (!type.getTypeName().equals(DynamicQuery.class.getName())) continue;
            return true;
        }
        return false;
    }

    protected Triple<PageParam, DynamicQuery, String> findPageAndDynamicObject(Object target) {
        PageParam pageparam = null;
        DynamicQuery query = null;
        String dynamicQueryParamName = null;
        if (target instanceof Map) {
            Map paramMap = (Map)target;
            for (Map.Entry entry : paramMap.entrySet()) {
                if (entry.getValue() instanceof PageParam) {
                    pageparam = (PageParam)entry.getValue();
                }
                if (!(entry.getValue() instanceof DynamicQuery)) continue;
                query = (DynamicQuery)entry.getValue();
                dynamicQueryParamName = (String)entry.getKey();
            }
        } else {
            query = (DynamicQuery)target;
        }
        return Triple.of(pageparam, (Object)query, dynamicQueryParamName);
    }

    protected SqlCommand createSqlCommand(String sql, SqlCommandType sqlCommandType) {
        return new SqlCommand(sql, sqlCommandType);
    }

    protected boolean isIgnoreUpdateField(String entityClassName, Field sourceField) {
        if (StringUtils.isBlank((CharSequence)entityClassName) || null == sourceField) {
            throw new IllegalArgumentException("entityClassName or sourceField is null");
        }
        Map<String, Set<String>> ignoreUpdateFields = this.dalProperties.getIgnoreUpdateFields();
        if (null == ignoreUpdateFields || null == ignoreUpdateFields.get(entityClassName)) {
            return false;
        }
        Set<String> ignoreFieldNames = ignoreUpdateFields.get(entityClassName);
        return ignoreFieldNames.contains(sourceField.getName());
    }
}

