/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.dynamicquery.DynamicQuery;
import com.cyberway.mp.bc.dal.dynamicquery.QuerySqlGen;
import com.cyberway.mp.bc.dal.generate.AbstractSqlGenerator;
import com.cyberway.mp.bc.dal.generate.QueryMergeParam;
import com.cyberway.mp.bc.dal.generate.parser.MethodNameParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.ParserResult;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class CountGenerator
extends AbstractSqlGenerator {
    private static final String COUNT = "count";
    private static final String COUNT_SQL_PREFIX = "select count(*) from ";
    private final List<String> specMethods = new ArrayList<String>();
    @Autowired
    private MethodNameParser methodNameParser;
    @Autowired
    private MethodParser methodParser;

    public void setMethodNameParser(MethodNameParser methodNameParser) {
        this.methodNameParser = methodNameParser;
    }

    public void setMethodParser(MethodParser methodParser) {
        this.methodParser = methodParser;
    }

    public CountGenerator() {
        this.specMethods.add(COUNT);
    }

    @Override
    public boolean match(Method method) {
        String name = method.getName();
        return this.match(name);
    }

    @Override
    public boolean match(String methodName) {
        for (String specMethod : this.specMethods) {
            if (!methodName.equals(specMethod)) continue;
            return true;
        }
        return methodName.startsWith(COUNT);
    }

    @Override
    public SqlCommand generate(Method method, Class<?> mapper) {
        if (this.isDynamicQuery(method)) {
            return new SqlCommand("select count(*) ", SqlCommandType.SELECT, true);
        }
        return this.commonGenerate(method, mapper);
    }

    private SqlCommand commonGenerate(Method method, Class<?> mapper) {
        Class<?> entityClass = EntityUtils.getEntityClass(mapper);
        String name = method.getName();
        Table table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class);
        if (name.equals(COUNT)) {
            String sql = this.generateCountSql(entityClass.getSimpleName(), table, entityClass);
            return this.createSqlCommand(sql, SqlCommandType.SELECT);
        }
        if (name.startsWith(COUNT)) {
            if (this.hasQueryBean(method, mapper)) {
                MethodParserResult result = this.methodParser.parse(method, mapper, false);
                return this.generateFromQueryBean(result, table, entityClass.getSimpleName(), entityClass);
            }
            String sql = this.generatePrefixCountSql(entityClass.getSimpleName(), name, table, entityClass);
            return this.createSqlCommand(sql, SqlCommandType.SELECT);
        }
        return null;
    }

    private String generatePrefixCountSql(String entityName, String name, Table table, Class<?> entityClass) {
        String methodRemovePrefix = name.substring(COUNT.length());
        ParserResult parserResult = this.methodNameParser.parse(methodRemovePrefix);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(COUNT_SQL_PREFIX);
        stringBuilder.append(this.findTableName(null, entityName, table));
        stringBuilder.append(parserResult.getPredicate().toSqlFrame(parserResult.getPredicate().hasScript(), (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class)));
        if (parserResult.getPredicate().hasScript()) {
            return String.format("<script>%s</script>", stringBuilder);
        }
        return stringBuilder.toString();
    }

    private String generateCountSql(String simpleName, Table table, Class<?> entityClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(COUNT_SQL_PREFIX);
        stringBuilder.append(this.findTableName(null, simpleName, table));
        return stringBuilder.toString();
    }

    private SqlCommand generateFromQueryBean(MethodParserResult result, Table table, String entityName, Class<?> entityClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(COUNT_SQL_PREFIX);
        Join join = result.getJoin();
        if (join != null) {
            stringBuilder.append(join.script());
        } else {
            stringBuilder.append(this.findTableName(result.getPredicateAnno(), entityName, table));
        }
        if (!result.sqlNeedMerge()) {
            stringBuilder.append(result.getPredicate().toSqlFrame(result.getPredicate().hasScript(), (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class)));
            return new SqlCommand(stringBuilder.toString(), SqlCommandType.SELECT);
        }
        return new SqlCommand(stringBuilder.toString(), SqlCommandType.SELECT, true);
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object target, String sqlFrame) {
        if (this.isDynamicQuery(method)) {
            return this.dynamicQueryMerge(target, sqlFrame);
        }
        QueryMergeParam queryMergeParam = new QueryMergeParam(target, sqlFrame, SqlCommandType.SELECT);
        return this.noneSearchQueryBeanMerge(queryMergeParam);
    }

    private SqlCommand dynamicQueryMerge(Object target, String sqlFrame) {
        Triple<PageParam, DynamicQuery, String> triple = this.findPageAndDynamicObject(target);
        DynamicQuery dynamicQuery = (DynamicQuery)triple.getMiddle();
        QuerySqlGen querySqlGen = new QuerySqlGen((String)triple.getRight(), true, this.sqlEscape);
        dynamicQuery.accept(querySqlGen);
        String partSql = querySqlGen.getSql();
        sqlFrame = (String)sqlFrame + partSql;
        return new SqlCommand((String)sqlFrame, SqlCommandType.SELECT);
    }
}

